/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.admin.nodeManagement.SnmpManagedNode;

public class SnmpGetNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = -9025129128736990895L;
    private static final String SNMP_SERVICE_QUERY = "SELECT serviceid FROM service WHERE servicename = 'SNMP'";
    private static final String NODE_QUERY = "SELECT DISTINCT node.nodeid, node.nodelabel FROM node, ipinterface, ifservices WHERE node.nodeid = ipinterface.nodeid AND ipinterface.id = ifservices.ipinterfaceid AND ifservices.serviceid = ? AND ipinterface.ismanaged != 'D' ORDER BY node.nodelabel, node.nodeid";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession user = request.getSession(true);
        try {
            user.setAttribute("listAllnodes.snmpmanage.jsp", this.getAllNodes(user));
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpmanage.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnmpManagedNode> getAllNodes(HttpSession userSession) throws SQLException {
        Connection connection = null;
        ArrayList<SnmpManagedNode> allNodes = new ArrayList<SnmpManagedNode>();
        int lineCount = 0;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)connection);
            int snmpServNum = 0;
            Statement servstmt = connection.createStatement();
            d.watch((Object)servstmt);
            ResultSet snmpserv = servstmt.executeQuery(SNMP_SERVICE_QUERY);
            d.watch((Object)snmpserv);
            if (snmpserv != null) {
                while (snmpserv.next()) {
                    snmpServNum = snmpserv.getInt(1);
                }
            }
            this.log("DEBUG: The SNMP service number is: " + snmpServNum);
            PreparedStatement stmt = connection.prepareStatement(NODE_QUERY);
            d.watch((Object)stmt);
            stmt.setInt(1, snmpServNum);
            ResultSet nodeSet = stmt.executeQuery();
            d.watch((Object)nodeSet);
            if (nodeSet != null) {
                while (nodeSet.next()) {
                    SnmpManagedNode newNode = new SnmpManagedNode();
                    newNode.setNodeID(nodeSet.getInt(1));
                    newNode.setNodeLabel(nodeSet.getString(2));
                    allNodes.add(newNode);
                }
            }
            userSession.setAttribute("lineNodeItems.snmpmanage.jsp", (Object)lineCount);
        }
        finally {
            d.cleanUp();
        }
        return allNodes;
    }
}

