/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DeleteNodesServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteNodesServlet.class);
    private static final long serialVersionUID = 573510937493956121L;
    private ResourceStorageDao m_resourceStorageDao;

    public void init() throws ServletException {
        WebApplicationContext webAppContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.m_resourceStorageDao = (ResourceStorageDao)webAppContext.getBean("resourceStorageDao", ResourceStorageDao.class);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List<Integer> nodeList = this.getList(request.getParameterValues("nodeCheck"));
        List<Integer> nodeDataList = this.getList(request.getParameterValues("nodeData"));
        for (Integer nodeId : nodeDataList) {
            List<String> ipAddrs = this.getIpAddrsForNode(nodeId);
            ResourcePath nodeSnmpPath = new ResourcePath(new String[]{"snmp", Integer.toString(nodeId)});
            if (this.m_resourceStorageDao.exists(nodeSnmpPath, 0)) {
                LOG.debug("Attempting to delete node data directory: {}", (Object)nodeSnmpPath);
                if (this.m_resourceStorageDao.delete(nodeSnmpPath)) {
                    LOG.info("Node SNMP data directory deleted successfully: {}", (Object)nodeSnmpPath);
                } else {
                    LOG.warn("Node SNMP data directory *not* deleted successfully: {}", (Object)nodeSnmpPath);
                }
            }
            for (String ipAddr : ipAddrs) {
                ResourcePath ifResponseTimePath = new ResourcePath(new String[]{"response", ipAddr});
                if (!this.m_resourceStorageDao.exists(ifResponseTimePath, 0)) continue;
                LOG.debug("Attempting to delete node response time data directory: {}", (Object)ifResponseTimePath);
                if (this.m_resourceStorageDao.delete(ifResponseTimePath)) {
                    LOG.info("Node response time data directory deleted successfully: {}", (Object)ifResponseTimePath);
                    continue;
                }
                LOG.warn("Node response time data directory *not* deleted successfully: {}", (Object)ifResponseTimePath);
            }
        }
        for (Integer nodeId : nodeList) {
            this.sendDeleteNodeEvent(nodeId);
            LOG.debug("End of delete of node {}", (Object)nodeId);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/deleteNodesFinish.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<String> getIpAddrsForNode(Integer nodeId) throws ServletException {
        ArrayList<String> ipAddrs = new ArrayList<String>();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT DISTINCT ipaddr FROM ipinterface WHERE nodeid=?");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipAddrs.add(rs.getString("ipaddr"));
            }
        }
        catch (SQLException e) {
            throw new ServletException("There was a problem with the database connection: " + String.valueOf(e), (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        return ipAddrs;
    }

    private void sendDeleteNodeEvent(int node) throws ServletException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/capsd/deleteNode", "web ui");
        bldr.setNodeid((long)node);
        bldr.addParam("txno", "webUI");
        this.sendEvent(bldr.getEvent());
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }

    private List<Integer> getList(String[] array) {
        if (array == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (String a : array) {
            list.add(WebSecurityUtils.safeParseInt((String)a));
        }
        return list;
    }
}

