/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import java.util.Arrays;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;

public final class AuthenticationVerifier
extends NdrObject {
    public int authenticationService;
    public int protectionLevel;
    public int contextId;
    public byte[] body;

    public AuthenticationVerifier() {
        this(0, 1, 0, null);
    }

    public AuthenticationVerifier(int authenticatorLength) {
        this(0, 1, 0, authenticatorLength);
    }

    public AuthenticationVerifier(int authenticationService, int protectionLevel, int contextId, int authenticatorLength) {
        this(authenticationService, protectionLevel, contextId, new byte[authenticatorLength]);
    }

    public AuthenticationVerifier(int authenticationService, int protectionLevel, int contextId, byte[] body) {
        this.authenticationService = authenticationService;
        this.protectionLevel = protectionLevel;
        this.contextId = contextId;
        this.body = body;
    }

    @Override
    public void decode(NetworkDataRepresentation ndr, NdrBuffer src) {
        src.align(4);
        this.authenticationService = src.dec_ndr_small();
        this.protectionLevel = src.dec_ndr_small();
        src.dec_ndr_small();
        this.contextId = src.dec_ndr_long();
        System.arraycopy(src.getBuffer(), src.getIndex(), this.body, 0, this.body.length);
        src.index += this.body.length;
    }

    @Override
    public void encode(NetworkDataRepresentation ndr, NdrBuffer dst) {
        int padding = dst.align(4, (byte)0);
        dst.enc_ndr_small(this.authenticationService);
        dst.enc_ndr_small(this.protectionLevel);
        dst.enc_ndr_small(padding);
        dst.enc_ndr_small(0);
        dst.enc_ndr_long(this.contextId);
        System.arraycopy(this.body, 0, dst.getBuffer(), dst.getIndex(), this.body.length);
        dst.advance(this.body.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AuthenticationVerifier)) {
            return false;
        }
        AuthenticationVerifier other = (AuthenticationVerifier)obj;
        return this.authenticationService == other.authenticationService && this.protectionLevel == other.protectionLevel && this.contextId == other.contextId && Arrays.equals(this.body, other.body);
    }

    public int hashCode() {
        return this.authenticationService ^ this.protectionLevel ^ this.contextId;
    }
}

