/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import org.opennms.core.utils.SystemInfoUtils;
import org.opennms.netmgt.events.api.EventIpcBroadcaster;
import org.opennms.netmgt.events.api.EventProcessor;
import org.opennms.netmgt.events.api.EventProcessorException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Header;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EventIpcBroadcastProcessor
implements EventProcessor,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventIpcBroadcastProcessor.class);
    private EventIpcBroadcaster m_eventIpcBroadcaster;
    private final Timer logBroadcastTimer;
    private final Meter eventBroadcastMeter;

    public EventIpcBroadcastProcessor(MetricRegistry registry) {
        this.logBroadcastTimer = Objects.requireNonNull(registry).timer("eventlogs.process.broadcast");
        this.eventBroadcastMeter = registry.meter("events.process.broadcast");
    }

    public void afterPropertiesSet() throws IllegalStateException {
        Assert.state((this.m_eventIpcBroadcaster != null ? 1 : 0) != 0, (String)"property eventIpcBroadcaster must be set");
    }

    public void process(Log eventLog) throws EventProcessorException {
        this.process(eventLog, false);
    }

    public void process(Log eventLog, boolean synchronous) throws EventProcessorException {
        if (eventLog != null && eventLog.getEvents() != null && eventLog.getEvents().getEvent() != null) {
            try (Timer.Context context = this.logBroadcastTimer.time();){
                for (Event eachEvent : eventLog.getEvents().getEvent()) {
                    this.process(eventLog.getHeader(), eachEvent, synchronous);
                    this.eventBroadcastMeter.mark();
                }
            }
        }
    }

    private void process(Header eventHeader, Event event, boolean synchronous) {
        if (event.getLogmsg() != null && event.getLogmsg().getDest().equals("suppress")) {
            LOG.debug("process: skip sending event {} to other daemons because is marked as suppress, instanceId={}, eventId={}", new Object[]{event.getUei(), SystemInfoUtils.getInstanceId(), event.getDbid()});
        } else {
            this.m_eventIpcBroadcaster.broadcastNow(event, synchronous);
        }
    }

    public EventIpcBroadcaster getEventIpcBroadcaster() {
        return this.m_eventIpcBroadcaster;
    }

    public void setEventIpcBroadcaster(EventIpcBroadcaster eventIpcManager) {
        this.m_eventIpcBroadcaster = eventIpcManager;
    }
}

