/*
 * Copyright 2000-2021 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.client.ui.upload;

import com.vaadin.client.ui.VUpload;

/**
 * An IFrame onload strategy class for an Upload component.
 *
 * @author Vaadin Ltd
 */
public class UploadIFrameOnloadStrategy {

    /**
     * Hooks the events to the given IFrame's onLoad event.
     *
     * @param iframe
     *            the iframe whose onLoad event should be connected
     * @param upload
     *            the upload widget
     */
    public native void hookEvents(com.google.gwt.dom.client.Element iframe,
            VUpload upload)
    /*-{
        iframe.onload = $entry(function() {
            upload.@com.vaadin.client.ui.VUpload::onSubmitComplete()();
        });
    }-*/;

    /**
     * @param iframe
     *            the iframe whose onLoad event is to be cleaned
     */
    public native void unHookEvents(com.google.gwt.dom.client.Element iframe)
    /*-{
        iframe.onload = null;
    }-*/;

}
