/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.config.api.CollectdConfigFactory;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.DomainResourceType;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.InterfaceSnmpByIfIndexResourceType;
import org.opennms.netmgt.dao.support.InterfaceSnmpResourceType;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.dao.support.NodeSnmpResourceType;
import org.opennms.netmgt.dao.support.PerspectiveResponseTimeResourceType;
import org.opennms.netmgt.dao.support.PerspectiveStatusResourceType;
import org.opennms.netmgt.dao.support.ResponseTimeResourceType;
import org.opennms.netmgt.dao.support.ServiceResourceType;
import org.opennms.netmgt.dao.support.ServiceStatusResourceType;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class DefaultResourceDao
implements ResourceDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceDao.class);
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("([^\\[]+)\\[([^\\]]*)\\](?:\\.|$)");
    public static final int MAXIMUM_NODE_METRIC_RESOURCE_DEPTH = 2;
    private ResourceStorageDao m_resourceStorageDao;
    private NodeDao m_nodeDao;
    private IpInterfaceDao m_ipInterfaceDao;
    private CollectdConfigFactory m_collectdConfig;
    private ResourceTypesDao m_resourceTypesDao;
    private Date m_lastUpdatedResourceTypesConfig;
    private Map<String, OnmsResourceType> m_resourceTypes = Maps.newHashMap();
    private NodeResourceType m_nodeResourceType;

    public ResourceTypesDao getResourceTypesDao() {
        return this.m_resourceTypesDao;
    }

    public void setResourceTypesDao(ResourceTypesDao resourceTypesDao) {
        this.m_resourceTypesDao = Objects.requireNonNull(resourceTypesDao);
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfig) {
        this.m_collectdConfig = collectdConfig;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
        if (this.m_resourceTypes.size() > 0) {
            this.initResourceTypes();
        }
    }

    public ResourceStorageDao getResourceStorageDao() {
        return this.m_resourceStorageDao;
    }

    public void afterPropertiesSet() {
        if (this.m_collectdConfig == null) {
            throw new IllegalStateException("collectdConfig property has not been set");
        }
        if (this.m_resourceTypesDao == null) {
            throw new IllegalStateException("resourceTypesDao property has not been set");
        }
        if (this.m_nodeDao == null) {
            throw new IllegalStateException("nodeDao property has not been set");
        }
        if (this.m_resourceStorageDao == null) {
            throw new IllegalStateException("resourceStorageDao property has not been set");
        }
        this.initResourceTypes();
    }

    private void initResourceTypes() {
        LinkedHashMap resourceTypes = Maps.newLinkedHashMap();
        Object resourceType = new NodeSnmpResourceType(this.m_resourceStorageDao);
        resourceTypes.put(resourceType.getName(), resourceType);
        InterfaceSnmpResourceType intfResourceType = new InterfaceSnmpResourceType(this.m_resourceStorageDao);
        resourceTypes.put(intfResourceType.getName(), intfResourceType);
        resourceType = new InterfaceSnmpByIfIndexResourceType(intfResourceType);
        resourceTypes.put(resourceType.getName(), resourceType);
        ServiceResourceType serviceResourceType = new ResponseTimeResourceType(this.m_resourceStorageDao, this.m_ipInterfaceDao);
        resourceType = serviceResourceType;
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceType = new PerspectiveResponseTimeResourceType(this.m_resourceStorageDao, serviceResourceType);
        resourceTypes.put(resourceType.getName(), resourceType);
        serviceResourceType = new ServiceStatusResourceType(this.m_resourceStorageDao, this.m_ipInterfaceDao);
        resourceType = serviceResourceType;
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceType = new PerspectiveStatusResourceType(this.m_resourceStorageDao, serviceResourceType);
        resourceTypes.put(resourceType.getName(), resourceType);
        resourceTypes.putAll(GenericIndexResourceType.createTypes(this.m_resourceTypesDao.getResourceTypes(), this.m_resourceStorageDao));
        this.m_nodeResourceType = new NodeResourceType(this, this.m_nodeDao);
        resourceTypes.put(this.m_nodeResourceType.getName(), this.m_nodeResourceType);
        resourceTypes.put("nodeSource", this.m_nodeResourceType);
        if (this.isDomainResourceTypeUsed()) {
            LOG.debug("One or more packages are configured with storeByIfAlias=true. Enabling the domain resource type.");
            resourceType = new DomainResourceType(this, this.m_resourceStorageDao);
            resourceTypes.put(resourceType.getName(), resourceType);
        } else {
            LOG.debug("No packages are configured with storeByIfAlias=true. Excluding the domain resource type.");
        }
        this.m_resourceTypes = resourceTypes;
        this.m_lastUpdatedResourceTypesConfig = this.m_resourceTypesDao.getLastUpdate();
    }

    public Collection<OnmsResourceType> getResourceTypes() {
        if (this.isResourceTypesConfigChanged()) {
            LOG.debug("The resource type configuration has been changed, reloading resource types.");
            this.initResourceTypes();
        }
        return this.m_resourceTypes.values();
    }

    @Transactional(readOnly=true)
    public List<OnmsResource> findTopLevelResources() {
        List<OnmsResource> resources = this.m_resourceTypes.values().stream().distinct().map(type -> type.getResourcesForParent(null)).flatMap(Collection::stream).filter(this::hasAnyChildResources).collect(Collectors.toList());
        return resources;
    }

    protected boolean hasAnyChildResources(OnmsResource resource) {
        return this.getResourceTypes().stream().anyMatch(t -> t.isResourceTypeOnParent(resource));
    }

    @Transactional(readOnly=true)
    public OnmsResource getResourceById(ResourceId id) {
        if (id == null) {
            return null;
        }
        try {
            return this.getChildResource(id.parent != null ? this.getResourceById(id.parent) : null, id.type, id.name);
        }
        catch (Throwable e) {
            LOG.warn("Could not get resource for resource ID \"{}\"", (Object)id, (Object)e);
            return null;
        }
    }

    public OnmsResource getResourceForNode(OnmsNode node) {
        Assert.notNull((Object)node, (String)"node argument must not be null");
        return this.m_nodeResourceType.createResourceForNode(node);
    }

    public boolean deleteResourceById(ResourceId resourceId) {
        OnmsResource resource = this.getResourceById(resourceId);
        if (resource == null) {
            return false;
        }
        return this.deleteResource(resource, true);
    }

    public boolean deleteResource(OnmsResource resource, boolean recursive) {
        boolean result = false;
        if (recursive) {
            for (OnmsResource childResource : resource.getChildResources()) {
                result = this.deleteResource(childResource, recursive) || result;
            }
        }
        result = this.m_resourceStorageDao.delete(resource.getPath()) || result;
        return result;
    }

    protected OnmsResource getChildResource(OnmsResource parentResource, String resourceType, String resource) {
        OnmsResourceType targetType = this.m_resourceTypes.get(resourceType);
        if (targetType == null) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Unsupported resource type: " + resourceType, null);
        }
        OnmsResource childResource = targetType.getChildByName(parentResource, resource);
        if (childResource != null) {
            LOG.debug("getChildResource: returning resource {}", (Object)childResource);
            return childResource;
        }
        throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)(resourceType + "/" + resource), "Could not find child resource '" + resource + "' with resource type '" + resourceType + "' on resource '" + resource + "'", null);
    }

    private boolean isResourceTypesConfigChanged() {
        Date current = this.m_resourceTypesDao.getLastUpdate();
        if (current.after(this.m_lastUpdatedResourceTypesConfig)) {
            this.m_lastUpdatedResourceTypesConfig = current;
            return true;
        }
        return false;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isDomainResourceTypeUsed() {
        for (Package pkg : this.m_collectdConfig.getPackages()) {
            if (!"true".equalsIgnoreCase(pkg.getStoreByIfAlias())) continue;
            return true;
        }
        return false;
    }

    public ResourceId getResourceId(CollectionResource resource, long nodeId) {
        String[] parts;
        if (resource == null) {
            return null;
        }
        String resourceType = resource.getResourceTypeName();
        String resourceLabel = resource.getInterfaceLabel();
        if ("node".equals(resourceType)) {
            resourceType = "nodeSnmp";
            resourceLabel = "";
        }
        if ("if".equals(resourceType)) {
            resourceType = "interfaceSnmp";
        }
        String parentResourceTypeName = "node";
        Object parentResourceName = String.valueOf(nodeId);
        if (resource.getParent() != null && resource.getParent().toString().startsWith("fs") && (parts = resource.getParent().toString().split(File.separatorChar == '\\' ? "\\\\" : File.separator)).length == 3) {
            parentResourceTypeName = "nodeSource";
            parentResourceName = parts[1] + ":" + parts[2];
        }
        return ResourceId.get((String)parentResourceTypeName, (String)parentResourceName).resolve(resourceType, resourceLabel);
    }
}

