/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.stats;

import java.util.List;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmStatisticsService;
import org.opennms.netmgt.dao.stats.AbstractBaseStatisticsService;
import org.opennms.netmgt.model.OnmsAlarm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DefaultAlarmStatisticsService
extends AbstractBaseStatisticsService<OnmsAlarm>
implements AlarmStatisticsService {
    @Autowired
    AlarmDao m_alarmDao;

    public AlarmDao getDao() {
        return this.m_alarmDao;
    }

    @Transactional
    public int getAcknowledgedCount(Criteria criteria) {
        criteria.addRestriction((Restriction)Restrictions.isNotNull((String)"alarmAckUser"));
        return this.m_alarmDao.countMatching(criteria);
    }

    @Transactional
    public OnmsAlarm getAcknowledged(Criteria criteria) {
        criteria.addRestriction((Restriction)Restrictions.isNotNull((String)"alarmAckUser"));
        criteria.setLimit(Integer.valueOf(1));
        List alarms = this.m_alarmDao.findMatching(criteria);
        if (alarms.size() == 0) {
            return null;
        }
        return (OnmsAlarm)alarms.get(0);
    }

    @Transactional
    public OnmsAlarm getUnacknowledged(Criteria criteria) {
        criteria.addRestriction((Restriction)Restrictions.isNull((String)"alarmAckUser"));
        criteria.setLimit(Integer.valueOf(1));
        List alarms = this.m_alarmDao.findMatching(criteria);
        if (alarms.size() == 0) {
            return null;
        }
        return (OnmsAlarm)alarms.get(0);
    }
}

