/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.converter.json;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.rest.api.Converter;
import org.opennms.netmgt.graph.rest.impl.converter.JsonPropertyConverterService;
import org.opennms.netmgt.graph.rest.impl.converter.json.GraphConverter;
import org.osgi.framework.BundleContext;

public class GraphContainerConverter
implements Converter<ImmutableGraphContainer<?>, JSONObject> {
    private final BundleContext bundleContext;

    public GraphContainerConverter(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public boolean canConvert(Class<ImmutableGraphContainer<?>> type) {
        return ImmutableGraphContainer.class.isAssignableFrom(type);
    }

    public JSONObject convert(ImmutableGraphContainer<?> input) {
        JSONObject jsonContainer = new JSONObject();
        JSONArray jsonGraphArray = new JSONArray();
        jsonContainer.put("graphs", (Object)jsonGraphArray);
        GenericGraphContainer genericGraphContainer = input.asGenericGraphContainer();
        Map properties = genericGraphContainer.getProperties();
        JSONObject convertedProperties = new JsonPropertyConverterService(this.bundleContext).convert(properties);
        convertedProperties.toMap().forEach((arg_0, arg_1) -> ((JSONObject)jsonContainer).put(arg_0, arg_1));
        genericGraphContainer.getProperties().forEach((key, value) -> jsonContainer.put(key, value));
        input.getGraphs().stream().sorted(Comparator.comparing(GraphInfo::getNamespace)).forEach(graph -> {
            JSONObject jsonGraph = new GraphConverter(this.bundleContext).convert((ImmutableGraph<?, ?>)graph);
            jsonGraphArray.put((Object)jsonGraph);
        });
        return jsonContainer;
    }
}

