/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic.mapping;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.factory.Mappers;
import org.opennms.features.alarms.history.elastic.dto.AlarmDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.MonitoringSystemDTO;
import org.opennms.features.alarms.history.elastic.dto.RelatedAlarmDocumentDTO;
import org.opennms.features.alarms.history.elastic.mapping.AlarmMapper;
import org.opennms.features.alarms.history.elastic.mapping.DateMapper;
import org.opennms.features.alarms.history.elastic.mapping.EventMapper;
import org.opennms.features.alarms.history.elastic.mapping.MemoMapper;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsMonitoringSystem;

public class AlarmMapperImpl
implements AlarmMapper {
    private final EventMapper eventMapper = (EventMapper)Mappers.getMapper(EventMapper.class);
    private final MemoMapper memoMapper = (MemoMapper)Mappers.getMapper(MemoMapper.class);
    private final DateMapper dateMapper = (DateMapper)Mappers.getMapper(DateMapper.class);

    @Override
    public AlarmDocumentDTO map(OnmsAlarm alarm, AlarmMapper.MappingContext mappingContext) {
        Set set;
        if (alarm == null) {
            return null;
        }
        AlarmDocumentDTO alarmDocumentDTO = new AlarmDocumentDTO();
        alarmDocumentDTO.setTicketId(alarm.getTTicketId());
        alarmDocumentDTO.setTicketStateId(this.mapTroubleTicketStateToInteger(alarm.getTTicketState()));
        alarmDocumentDTO.setTicketStateName(this.mapTroubleTicketStateToString(alarm.getTTicketState()));
        alarmDocumentDTO.setType(alarm.getAlarmType());
        Map map = alarm.getDetails();
        if (map != null) {
            alarmDocumentDTO.setAttributes(new LinkedHashMap<String, String>(map));
        }
        alarmDocumentDTO.setIpAddress(this.mapIpAddressToString(alarm.getIpAddr()));
        alarmDocumentDTO.setLogMessage(alarm.getLogMsg());
        alarmDocumentDTO.setOperatorInstructions(alarm.getOperInstruct());
        alarmDocumentDTO.setJournalMemo(this.memoMapper.map((OnmsMemo)alarm.getReductionKeyMemo()));
        alarmDocumentDTO.setFirstEventTime(this.dateMapper.map(alarm.getFirstEventTime()));
        alarmDocumentDTO.setLastEventTime(this.dateMapper.map(alarm.getLastEventTime()));
        alarmDocumentDTO.setAckTime(this.dateMapper.map(alarm.getAckTime()));
        alarmDocumentDTO.setAckUser(alarm.getAckUser());
        alarmDocumentDTO.setApplicationDN(alarm.getApplicationDN());
        alarmDocumentDTO.setArchived(alarm.isArchived());
        alarmDocumentDTO.setClearKey(alarm.getClearKey());
        alarmDocumentDTO.setCounter(alarm.getCounter());
        alarmDocumentDTO.setDescription(alarm.getDescription());
        alarmDocumentDTO.setDistPoller(this.onmsMonitoringSystemToMonitoringSystemDTO(alarm.getDistPoller(), mappingContext));
        alarmDocumentDTO.setFirstAutomationTime(this.dateMapper.map(alarm.getFirstAutomationTime()));
        alarmDocumentDTO.setId(alarm.getId());
        alarmDocumentDTO.setIfIndex(alarm.getIfIndex());
        alarmDocumentDTO.setLastAutomationTime(this.dateMapper.map(alarm.getLastAutomationTime()));
        alarmDocumentDTO.setLastEvent(this.eventMapper.map(alarm.getLastEvent()));
        alarmDocumentDTO.setManagedObjectInstance(alarm.getManagedObjectInstance());
        alarmDocumentDTO.setManagedObjectType(alarm.getManagedObjectType());
        alarmDocumentDTO.setMouseOverText(alarm.getMouseOverText());
        alarmDocumentDTO.setOssPrimaryKey(alarm.getOssPrimaryKey());
        alarmDocumentDTO.setPartOfSituation(alarm.isPartOfSituation());
        alarmDocumentDTO.setQosAlarmState(alarm.getQosAlarmState());
        alarmDocumentDTO.setReductionKey(alarm.getReductionKey());
        alarmDocumentDTO.setRelatedAlarms(this.onmsAlarmSetToRelatedAlarmDocumentDTOList(alarm.getRelatedAlarms(), mappingContext));
        alarmDocumentDTO.setServiceType(this.mapServiceTypeToString(alarm.getServiceType()));
        alarmDocumentDTO.setSeverityId(alarm.getSeverityId());
        alarmDocumentDTO.setSeverityLabel(alarm.getSeverityLabel());
        alarmDocumentDTO.setSituation(alarm.isSituation());
        alarmDocumentDTO.setStickyMemo(this.memoMapper.map(alarm.getStickyMemo()));
        alarmDocumentDTO.setSuppressedTime(this.dateMapper.map(alarm.getSuppressedTime()));
        alarmDocumentDTO.setSuppressedUntil(this.dateMapper.map(alarm.getSuppressedUntil()));
        alarmDocumentDTO.setSuppressedUser(alarm.getSuppressedUser());
        alarmDocumentDTO.setX733AlarmType(alarm.getX733AlarmType());
        alarmDocumentDTO.setX733ProbableCause(alarm.getX733ProbableCause());
        if (alarmDocumentDTO.getRelatedAlarmIds() != null && (set = alarm.getRelatedAlarmIds()) != null) {
            alarmDocumentDTO.getRelatedAlarmIds().addAll(set);
        }
        this.afterMapping(alarm, alarmDocumentDTO, mappingContext);
        return alarmDocumentDTO;
    }

    protected MonitoringSystemDTO onmsMonitoringSystemToMonitoringSystemDTO(OnmsMonitoringSystem onmsMonitoringSystem, AlarmMapper.MappingContext mappingContext) {
        if (onmsMonitoringSystem == null) {
            return null;
        }
        MonitoringSystemDTO monitoringSystemDTO = new MonitoringSystemDTO();
        monitoringSystemDTO.setId(onmsMonitoringSystem.getId());
        monitoringSystemDTO.setLabel(onmsMonitoringSystem.getLabel());
        monitoringSystemDTO.setLocation(onmsMonitoringSystem.getLocation());
        return monitoringSystemDTO;
    }

    protected RelatedAlarmDocumentDTO onmsAlarmToRelatedAlarmDocumentDTO(OnmsAlarm onmsAlarm, AlarmMapper.MappingContext mappingContext) {
        if (onmsAlarm == null) {
            return null;
        }
        RelatedAlarmDocumentDTO relatedAlarmDocumentDTO = new RelatedAlarmDocumentDTO();
        relatedAlarmDocumentDTO.setFirstEventTime(this.dateMapper.map(onmsAlarm.getFirstEventTime()));
        relatedAlarmDocumentDTO.setId(onmsAlarm.getId());
        relatedAlarmDocumentDTO.setLastEvent(this.eventMapper.map(onmsAlarm.getLastEvent()));
        relatedAlarmDocumentDTO.setLastEventTime(this.dateMapper.map(onmsAlarm.getLastEventTime()));
        relatedAlarmDocumentDTO.setManagedObjectInstance(onmsAlarm.getManagedObjectInstance());
        relatedAlarmDocumentDTO.setManagedObjectType(onmsAlarm.getManagedObjectType());
        relatedAlarmDocumentDTO.setReductionKey(onmsAlarm.getReductionKey());
        relatedAlarmDocumentDTO.setSeverityId(onmsAlarm.getSeverityId());
        relatedAlarmDocumentDTO.setSeverityLabel(onmsAlarm.getSeverityLabel());
        return relatedAlarmDocumentDTO;
    }

    protected List<RelatedAlarmDocumentDTO> onmsAlarmSetToRelatedAlarmDocumentDTOList(Set<OnmsAlarm> set, AlarmMapper.MappingContext mappingContext) {
        if (set == null) {
            return null;
        }
        ArrayList<RelatedAlarmDocumentDTO> list = new ArrayList<RelatedAlarmDocumentDTO>(set.size());
        for (OnmsAlarm onmsAlarm : set) {
            list.add(this.onmsAlarmToRelatedAlarmDocumentDTO(onmsAlarm, mappingContext));
        }
        return list;
    }
}

