/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.BlockingQueue;
import org.opennms.features.alarms.history.elastic.tasks.Task;

public class ElasticAlarmMetrics {
    private final Histogram bulkIndexSizeHistogram;
    private final Timer bulkIndexTimer;
    private final Timer bulkDeleteTimer;
    private final Counter tasksFailedCounter;

    public ElasticAlarmMetrics(MetricRegistry metrics, BlockingQueue<Task> taskQueue) {
        this.bulkIndexSizeHistogram = metrics.histogram("bulk-index-size");
        this.bulkIndexTimer = metrics.timer("bulk-index-timer");
        this.bulkDeleteTimer = metrics.timer("bulk-delete-timer");
        this.tasksFailedCounter = metrics.counter("tasks-failed");
        metrics.register("task-queue-size", (Metric)((Gauge)taskQueue::size));
    }

    public Histogram getBulkIndexSizeHistogram() {
        return this.bulkIndexSizeHistogram;
    }

    public Timer getBulkIndexTimer() {
        return this.bulkIndexTimer;
    }

    public Timer getBulkDeleteTimer() {
        return this.bulkDeleteTimer;
    }

    public Counter getTasksFailedCounter() {
        return this.tasksFailedCounter;
    }
}

