/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;
import org.sblim.wbem.util.SessionProperties;

public class HttpHeader {
    private static BitSet cDontNeedEncoding;
    private static final String HEX_STR = "0123456789ABCDEF";
    private static String cDfltEncName;
    private Hashtable iFields = new Hashtable();

    public HttpHeader() {
    }

    public HttpHeader(InputStream reader) throws IOException {
        String line = null;
        while ((line = HttpMethod.readLine(reader)) != null && line.length() > 0) {
            Logger logger;
            try {
                int separator = line.indexOf(58);
                if (separator > -1) {
                    String header = line.substring(0, separator);
                    String value = line.substring(separator + 1);
                    if (value.length() > 0 && value.startsWith(" ")) {
                        this.addField(header, value.substring(1));
                        continue;
                    }
                    this.addField(header, value);
                    continue;
                }
                logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "invalid HTTP Header \"" + line + "\"");
            }
            catch (Exception e) {
                logger = SessionProperties.getGlobalProperties().getLogger();
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "exception while closing the socket");
            }
        }
    }

    public void addField(String header, String value) {
        if (header == null || header.length() == 0) {
            return;
        }
        if (value != null) {
            this.iFields.put(new HeaderEntry(header), value);
        } else {
            this.iFields.remove(new HeaderEntry(header));
        }
    }

    public void clear() {
        this.iFields.clear();
    }

    public Iterator iterator() {
        return this.iFields.entrySet().iterator();
    }

    public static HttpHeader parse(String line) {
        int prev = 0;
        int next = 0;
        HttpHeader header = new HttpHeader();
        if (line != null && line.length() > 0) {
            int separator;
            String hdr;
            next = line.indexOf(44);
            while (next > -1) {
                hdr = line.substring(prev, next);
                separator = hdr.indexOf(61);
                if (separator > -1) {
                    String key = hdr.substring(0, separator);
                    String value = hdr.substring(separator + 1);
                    header.addField(key, value);
                }
                prev = next + 1;
                while (Character.isSpaceChar(line.charAt(prev))) {
                    ++prev;
                }
                next = line.indexOf(44, prev);
            }
            hdr = line.substring(prev);
            separator = hdr.indexOf(61);
            if (separator > -1) {
                header.addField(hdr.substring(0, separator), hdr.substring(separator + 1));
            }
        }
        return header;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        Iterator iterator = this.iFields.entrySet().iterator();
        while (iterator.hasNext()) {
            if (i++ > 0) {
                buf.append(',');
            }
            Map.Entry entry = iterator.next();
            buf.append(entry.getKey().toString());
            buf.append(": ");
            buf.append(entry.getValue().toString());
        }
        return buf.toString();
    }

    public void removeField(String header) {
        this.iFields.remove(new HeaderEntry(header));
    }

    public String getField(String header) {
        return (String)this.iFields.get(new HeaderEntry(header));
    }

    public void write(ASCIIPrintStream writer) throws IOException {
        Iterator iterator = this.iFields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            writer.print(entry.getKey().toString());
            writer.print(": ");
            writer.print(entry.getValue().toString());
            writer.print("\r\n");
        }
        writer.print("\r\n");
    }

    public static synchronized String encode(byte[] byteArray) {
        String str = null;
        try {
            if (cDfltEncName == null) {
                cDfltEncName = (String)AccessController.doPrivileged(new GetProperty("file.encoding"));
            }
            str = HttpHeader.encode(byteArray, cDfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(byte[] byteArray, String enc) throws UnsupportedEncodingException {
        int maxBytesPerChar = 10;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        StringBuffer out = new StringBuffer(byteArray.length);
        for (int i = 0; i < byteArray.length; ++i) {
            int c = byteArray[i] & 0xFF;
            if (cDontNeedEncoding.get(c)) {
                if (c == 32) {
                    out.append("%20");
                    continue;
                }
                out.append((char)c);
                continue;
            }
            out.append('%');
            out.append(HEX_STR.charAt(c >> 4 & 0xF));
            out.append(HEX_STR.charAt(c & 0xF));
        }
        return out.toString();
    }

    public static String encode(String s, String source, String dest) throws UnsupportedEncodingException {
        return HttpHeader.encode(s.getBytes(source), dest);
    }

    static {
        int i;
        cDfltEncName = null;
        cDontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            cDontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            cDontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            cDontNeedEncoding.set(i);
        }
        cDontNeedEncoding.set(32);
        cDontNeedEncoding.set(45);
        cDontNeedEncoding.set(95);
        cDontNeedEncoding.set(47);
        cDontNeedEncoding.set(46);
        cDontNeedEncoding.set(42);
    }

    static class GetProperty
    implements PrivilegedAction {
        String iPropertyName;

        GetProperty(String propertyName) {
            this.iPropertyName = propertyName;
        }

        public Object run() {
            return System.getProperty(this.iPropertyName);
        }
    }

    class HeaderEntry {
        String iHeader;
        int iHashcode;

        public HeaderEntry(String header) {
            this.iHeader = header;
            this.iHashcode = header.toUpperCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderEntry)) {
                return false;
            }
            return this.iHeader.equalsIgnoreCase(((HeaderEntry)obj).iHeader);
        }

        public String toString() {
            return this.iHeader;
        }

        public int hashCode() {
            return this.iHashcode;
        }
    }
}

