/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp6;

import java.nio.ByteBuffer;

public class ICMPv6Packet {
    public static final int CHECKSUM_INDEX = 2;
    public static final int HEADER_OFFSET_TYPE = 0;
    public static final int HEADER_OFFSET_CODE = 1;
    public static final int HEADER_OFFSET_CHECKSUM = 2;
    ByteBuffer m_packetData;

    public ICMPv6Packet(byte[] bytes, int offset, int length) {
        this(ByteBuffer.wrap(bytes, offset, length));
    }

    public ICMPv6Packet(ByteBuffer ipPayload) {
        this.m_packetData = ipPayload;
    }

    public ICMPv6Packet(ICMPv6Packet icmpPacket) {
        this(icmpPacket.m_packetData.duplicate());
    }

    public ICMPv6Packet(int size) {
        this(ByteBuffer.allocate(size));
    }

    public int getPacketLength() {
        return this.m_packetData.limit();
    }

    public Type getType() {
        return Type.toType(this.m_packetData.get(0));
    }

    public void setType(Type t) {
        this.m_packetData.put(0, (byte)t.getCode());
    }

    public int getCode() {
        return 0xFF & this.m_packetData.get(1);
    }

    public void setCode(int code) {
        this.m_packetData.put(1, (byte)code);
    }

    public int getChecksum() {
        return this.getUnsignedShort(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int index, byte[] b) {
        ByteBuffer payload = this.m_packetData;
        int oldPos = payload.position();
        try {
            payload.position(index);
            payload.put(b);
        }
        finally {
            payload.position(oldPos);
        }
    }

    public int makeUnsignedShort(byte b1, byte b0) {
        return 0xFFFF & ((b1 & 0xFF) << 8 | (b0 & 0xFF) << 0);
    }

    public int getUnsignedShort(int index) {
        return this.m_packetData.getShort(index) & 0xFFFF;
    }

    public void setUnsignedShort(int index, int us) {
        this.m_packetData.putShort(index, (short)(us & 0xFFFF));
    }

    public final byte[] toBytes() {
        return this.m_packetData.array();
    }

    public static enum Type {
        DestinationUnreachable(1),
        TimeExceeded(3),
        EchoRequest(128),
        EchoReply(129),
        Other(-1);

        private int m_code;

        private Type(int code) {
            this.m_code = code;
        }

        public int getCode() {
            return this.m_code;
        }

        public static Type toType(byte typeCode) {
            int code = typeCode & 0xFF;
            for (Type p : Type.values()) {
                if (code != p.getCode()) continue;
                return p;
            }
            return Other;
        }
    }
}

