/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.graphml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.provider.graphml.GraphmlGraphContainerProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLContainerProviderServiceFactory
implements ManagedServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLContainerProviderServiceFactory.class);
    private static final String GRAPH_LOCATION = "graphLocation";
    private final BundleContext bundleContext;
    private final Map<String, List<ServiceRegistration<?>>> containerRegistrations = Maps.newHashMap();

    public GraphMLContainerProviderServiceFactory(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public String getName() {
        return "This Factory creates GraphML Container Providers";
    }

    public void updated(String pid, Dictionary properties) {
        LOG.debug("updated(String, Dictionary) invoked");
        if (!this.containerRegistrations.containsKey(pid)) {
            LOG.debug("Service with pid '{}' is new. Register {}", (Object)pid, (Object)GraphmlGraphContainerProvider.class.getSimpleName());
            Hashtable<String, Object> metaData = new Hashtable<String, Object>();
            ((Dictionary)metaData).put("service.pid", pid);
            String location = (String)properties.get(GRAPH_LOCATION);
            try {
                GraphmlGraphContainerProvider graphmlGraphContainerProvider = new GraphmlGraphContainerProvider(location);
                this.registerService(pid, GraphContainerProvider.class, graphmlGraphContainerProvider, metaData);
            }
            catch (IOException | InvalidGraphException e) {
                LOG.error("An error occurred while loading GraphMLContainerProvider from file {}. Ignoring...", (Object)location, (Object)e);
            }
        } else {
            LOG.warn("Service with pid '{}' updated. Updating is not supported. Ignoring...");
        }
    }

    public void deleted(String pid) {
        LOG.debug("deleted(String) invoked");
        List<ServiceRegistration<?>> serviceRegistrations = this.containerRegistrations.get(pid);
        if (serviceRegistrations != null) {
            LOG.debug("Unregister services for pid '{}'", (Object)pid);
            serviceRegistrations.forEach(ServiceRegistration::unregister);
            this.containerRegistrations.remove(pid);
        }
    }

    private <T> void registerService(String pid, Class<T> serviceType, T serviceImpl, Dictionary<String, Object> serviceProperties) {
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(serviceType, serviceImpl, serviceProperties);
        this.containerRegistrations.putIfAbsent(pid, Lists.newArrayList());
        this.containerRegistrations.get(pid).add(serviceRegistration);
    }
}

