/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.service.util;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;
import org.opennms.features.config.service.api.JsonAsString;

public class PropertiesConversionUtil {
    public static Map<String, Object> jsonToMap(String jsonString) {
        JSONObject json = new JSONObject(Objects.requireNonNull(jsonString));
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        for (String key : json.keySet()) {
            Object value = json.get(key);
            if (value == null || JSONObject.NULL.equals(value)) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Properties jsonToProperties(String json) {
        Objects.requireNonNull(json);
        Properties props = new Properties();
        props.putAll(PropertiesConversionUtil.jsonToMap(json));
        return props;
    }

    public static JsonAsString mapToJsonString(Map<String, ?> map) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                value = JSONObject.NULL;
            }
            json.put(entry.getKey().toString(), value);
        }
        return new JsonAsString(json.toString());
    }
}

