/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.extender;

import java.util.Objects;

public class Feature {
    private final String name;
    private final String version;
    private final String karDependency;

    private Feature(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.karDependency = builder.karDependency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKarDependency() {
        return this.karDependency;
    }

    public String toInstallString() {
        return this.getVersion() != null ? this.getName() + "/" + this.getVersion() : this.getName();
    }

    public String toString() {
        return String.format("Feature[name=%s, version=%s, karDependency=%s]", this.name, this.version, this.karDependency);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.karDependency);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.karDependency, other.karDependency);
    }

    public static class Builder {
        private String name;
        private String version;
        private String karDependency;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withKarDependency(String karDependency) {
            this.karDependency = karDependency;
            return this;
        }

        public Feature build() {
            Objects.requireNonNull(this.name, "name is required");
            return new Feature(this);
        }
    }
}

