/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.status;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.opennms.minion.status.MinionServiceStatus;
import org.opennms.minion.status.MinionStatus;

public class AggregateMinionStatus
implements MinionStatus,
Comparable<AggregateMinionStatus>,
Serializable {
    private static final Comparator<AggregateMinionStatus> COMPARATOR = Comparator.comparing(AggregateMinionStatus::getHeartbeatStatus).thenComparing(AggregateMinionStatus::getRpcStatus);
    private static final long serialVersionUID = 1L;
    private MinionServiceStatus m_heartbeatStatus;
    private MinionServiceStatus m_rpcStatus;

    protected AggregateMinionStatus(MinionServiceStatus heartbeat, MinionServiceStatus rpc) {
        this.m_heartbeatStatus = heartbeat;
        this.m_rpcStatus = rpc;
    }

    public static AggregateMinionStatus create(MinionServiceStatus heartbeat, MinionServiceStatus rpc) {
        return new AggregateMinionStatus(heartbeat, rpc);
    }

    public static AggregateMinionStatus down() {
        return new AggregateMinionStatus(MinionServiceStatus.down(), MinionServiceStatus.down());
    }

    public static AggregateMinionStatus up() {
        return new AggregateMinionStatus(MinionServiceStatus.up(), MinionServiceStatus.up());
    }

    public MinionServiceStatus getHeartbeatStatus() {
        return this.m_heartbeatStatus;
    }

    public MinionServiceStatus getRpcStatus() {
        return this.m_rpcStatus;
    }

    @Override
    public MinionStatus.State getState() {
        return this.m_heartbeatStatus.getState() == UP && this.m_rpcStatus.getState() == UP ? UP : DOWN;
    }

    @Override
    public boolean isUp() {
        return this.m_heartbeatStatus.isUp() && this.m_rpcStatus.isUp();
    }

    public AggregateMinionStatus heartbeatDown() {
        return new AggregateMinionStatus(MinionServiceStatus.down(), this.m_rpcStatus);
    }

    public AggregateMinionStatus heartbeatUp() {
        return new AggregateMinionStatus(MinionServiceStatus.up(), this.m_rpcStatus);
    }

    public AggregateMinionStatus rpcDown() {
        return new AggregateMinionStatus(this.m_heartbeatStatus, MinionServiceStatus.down());
    }

    public AggregateMinionStatus rpcUp() {
        return new AggregateMinionStatus(this.m_heartbeatStatus, MinionServiceStatus.up());
    }

    @Override
    public int compareTo(AggregateMinionStatus o) {
        return COMPARATOR.compare(this, o);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AggregateMinionStatus) {
            AggregateMinionStatus status = (AggregateMinionStatus)o;
            return Objects.equals(this.m_heartbeatStatus, status.m_heartbeatStatus) && Objects.equals(this.m_rpcStatus, status.m_rpcStatus);
        }
        return false;
    }

    public String toString() {
        return "AggregateMinionStatus[Heartbeat=" + String.valueOf(this.m_heartbeatStatus) + ", RPC=" + String.valueOf(this.m_rpcStatus) + "]";
    }
}

