/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.transform.ResultTransformer;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsHwEntityAlias;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class HwEntityDaoHibernate
extends AbstractDaoHibernate<OnmsHwEntity, Integer>
implements HwEntityDao {
    public HwEntityDaoHibernate() {
        super(OnmsHwEntity.class);
    }

    @Override
    public OnmsHwEntity findRootByNodeId(Integer nodeId) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.parent is null and e.node.id = ?", nodeId);
    }

    @Override
    public OnmsHwEntity findRootEntityByNodeId(Integer nodeId) {
        List entityList = (List)this.getHibernateTemplate().execute(session -> session.createSQLQuery("select * FROM hwEntity where nodeid = " + nodeId).setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] tuple, String[] strings) {
                OnmsHwEntity onmsHwEntity = new OnmsHwEntity();
                onmsHwEntity.setId((Integer)tuple[0]);
                onmsHwEntity.setParentId((Integer)tuple[1]);
                onmsHwEntity.setNodeId((Integer)tuple[2]);
                onmsHwEntity.setEntPhysicalIndex((Integer)tuple[3]);
                onmsHwEntity.setEntPhysicalParentRelPos((Integer)tuple[4]);
                onmsHwEntity.setEntPhysicalName((String)tuple[5]);
                onmsHwEntity.setEntPhysicalDescr((String)tuple[6]);
                onmsHwEntity.setEntPhysicalAlias((String)tuple[7]);
                onmsHwEntity.setEntPhysicalVendorType((String)tuple[8]);
                onmsHwEntity.setEntPhysicalClass((String)tuple[9]);
                onmsHwEntity.setEntPhysicalMfgName((String)tuple[10]);
                onmsHwEntity.setEntPhysicalModelName((String)tuple[11]);
                onmsHwEntity.setEntPhysicalHardwareRev((String)tuple[12]);
                onmsHwEntity.setEntPhysicalFirmwareRev((String)tuple[13]);
                onmsHwEntity.setEntPhysicalSoftwareRev((String)tuple[14]);
                onmsHwEntity.setEntPhysicalSerialNum((String)tuple[15]);
                onmsHwEntity.setEntPhysicalAssetID((String)tuple[16]);
                onmsHwEntity.setEntPhysicalIsFRU((Boolean)tuple[17]);
                onmsHwEntity.setEntPhysicalMfgDate((Date)tuple[18]);
                onmsHwEntity.setEntPhysicalUris((String)tuple[19]);
                return onmsHwEntity;
            }

            public List transformList(List list) {
                return list;
            }
        }).list());
        Optional<OnmsHwEntity> optionalHwEntity = entityList.stream().filter(hwEntity -> hwEntity.getParentId() == null).findFirst();
        if (optionalHwEntity.isPresent()) {
            OnmsHwEntity parent = optionalHwEntity.get();
            List<OnmsHwEntityAlias> hwEntityAliases = this.findHwEntityAlias(parent);
            parent.addHwEntAliasList(hwEntityAliases);
            this.findChildren(parent, entityList);
            return parent;
        }
        return null;
    }

    private void findChildren(OnmsHwEntity parent, List<OnmsHwEntity> hwEntityList) {
        Set<OnmsHwEntity> children = hwEntityList.stream().filter(hwEntity -> hwEntity.getParentId() != null && hwEntity.getParentId().equals(parent.getId())).collect(Collectors.toSet());
        children.forEach(hwEntity -> {
            List<OnmsHwEntityAlias> onmsHwEntityAliases = this.findHwEntityAlias((OnmsHwEntity)hwEntity);
            hwEntity.addHwEntAliasList(onmsHwEntityAliases);
            this.findChildren((OnmsHwEntity)hwEntity, hwEntityList);
            parent.addChildEntity(hwEntity);
        });
    }

    private List<OnmsHwEntityAlias> findHwEntityAlias(OnmsHwEntity parent) {
        List hwEntityAliases = (List)this.getHibernateTemplate().execute(session -> session.createSQLQuery("SELECT * FROM hwEntityAlias WHERE hwEntityId = " + parent.getId()).setResultTransformer(new ResultTransformer(){

            public Object transformTuple(Object[] tuple, String[] strings) {
                OnmsHwEntityAlias onmsHwEntityAlias = new OnmsHwEntityAlias();
                onmsHwEntityAlias.setId((Integer)tuple[0]);
                onmsHwEntityAlias.setHwEntityId((Integer)tuple[1]);
                onmsHwEntityAlias.setIndex((Integer)tuple[2]);
                onmsHwEntityAlias.setOid((String)tuple[3]);
                return onmsHwEntityAlias;
            }

            public List transformList(List list) {
                return list;
            }
        }).list());
        return hwEntityAliases;
    }

    @Override
    public OnmsHwEntity findEntityByIndex(Integer nodeId, Integer entPhysicalIndex) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.node.id = ? and e.entPhysicalIndex = ?", nodeId, entPhysicalIndex);
    }

    @Override
    public OnmsHwEntity findEntityByName(Integer nodeId, String entPhysicalName) {
        return (OnmsHwEntity)this.findUnique("from OnmsHwEntity e where e.node.id = ? and e.entPhysicalName = ?", nodeId, entPhysicalName);
    }

    @Override
    public String getAttributeValue(Integer nodeId, Integer entPhysicalIndex, String attributeName) {
        OnmsHwEntity e = this.findEntityByIndex(nodeId, entPhysicalIndex);
        return e == null ? null : this.getAttributeValue(e, attributeName);
    }

    @Override
    public String getAttributeValue(Integer nodeId, String nameSource, String attributeName) {
        boolean isRegex = nameSource.startsWith("~");
        if (isRegex) {
            OnmsHwEntity r = this.findRootByNodeId(nodeId);
            return r == null ? null : this.findAttribute(r, nameSource.substring(1), attributeName);
        }
        OnmsHwEntity e = this.findEntityByName(nodeId, nameSource);
        return e == null ? null : this.getAttributeValue(e, attributeName);
    }

    private String findAttribute(OnmsHwEntity entity, String nameRegex, String attributeName) {
        if (entity.getEntPhysicalName().matches(nameRegex)) {
            return this.getAttributeValue(entity, attributeName);
        }
        for (OnmsHwEntity c : entity.getChildren()) {
            String v = this.findAttribute(c, nameRegex, attributeName);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private String getAttributeValue(OnmsHwEntity entity, String attributeName) {
        if (attributeName.startsWith("entPhysical")) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            if (wrapper.isWritableProperty(attributeName)) {
                return (String)wrapper.getPropertyValue(attributeName);
            }
        } else {
            return entity.getAttributeValue(attributeName);
        }
        return null;
    }
}

