/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.jaas;

import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.opennms.container.jaas.JaasSupport;
import org.opennms.netmgt.config.api.UserConfig;
import org.opennms.web.springframework.security.LoginModuleUtils;
import org.opennms.web.springframework.security.OpenNMSLoginHandler;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;

public class OpenNMSLoginModule
extends AbstractKarafLoginModule
implements OpenNMSLoginHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(OpenNMSLoginModule.class);
    private Map<String, ?> m_sharedState;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOG.info("OpenNMS Login Module initializing: subject={}, callbackHandler={}, sharedState={}, options={}", new Object[]{subject, callbackHandler, sharedState, options});
        this.m_sharedState = sharedState;
        super.initialize(subject, callbackHandler, options);
    }

    public boolean login() throws LoginException {
        this.succeeded = LoginModuleUtils.doLogin((OpenNMSLoginHandler)this, (Subject)this.subject, this.m_sharedState, (Map)this.options);
        return this.succeeded;
    }

    public boolean abort() throws LoginException {
        return super.abort();
    }

    public boolean logout() throws LoginException {
        return super.logout();
    }

    public CallbackHandler callbackHandler() {
        return this.callbackHandler;
    }

    public UserConfig userConfig() {
        return JaasSupport.getUserConfig();
    }

    public SpringSecurityUserDao springSecurityUserDao() {
        return JaasSupport.getSpringSecurityUserDao();
    }

    public String user() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Set<Principal> createPrincipals(GrantedAuthority authority) {
        String role = authority.getAuthority().replaceFirst("^[Rr][Oo][Ll][Ee]_", "");
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add((Principal)new RolePrincipal(role));
        principals.add((Principal)new RolePrincipal(role.toLowerCase()));
        principals.add((Principal)new RolePrincipal(authority.getAuthority()));
        LOG.debug("created principals from authority {}: {}", (Object)authority, principals);
        return principals;
    }

    public Set<Principal> principals() {
        return this.principals;
    }

    public void setPrincipals(Set<Principal> principals) {
        this.principals = principals;
    }

    public boolean requiresAdminRole() {
        return true;
    }
}

