/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.search;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.AnnotationException;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class HibernateSearchEventListenerRegister {
    private static final Logger log = LoggerFactory.getLogger(HibernateSearchEventListenerRegister.class);
    private static final String FULL_TEXT_INDEX_EVENT_LISTENER_CLASS = "org.hibernate.search.event.FullTextIndexEventListener";

    @Deprecated
    public static void enableHibernateSearch(EventListeners eventListeners, Properties properties) {
        Serializable eventListener2;
        int n;
        String enableSearchListeners = properties.getProperty("hibernate.search.autoregister_listeners");
        if ("false".equalsIgnoreCase(enableSearchListeners)) {
            log.info("Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.");
            return;
        }
        Class<?> searchEventListenerClass = HibernateSearchEventListenerRegister.attemptToLoadSearchEventListener();
        if (searchEventListenerClass == null) {
            log.info("Unable to find {} on the classpath. Hibernate Search is not enabled.", (Object)FULL_TEXT_INDEX_EVENT_LISTENER_CLASS);
            return;
        }
        Object searchEventListener = HibernateSearchEventListenerRegister.instantiateEventListener(searchEventListenerClass);
        boolean present = false;
        Serializable[] listeners = eventListeners.getPostInsertEventListeners();
        if (listeners != null) {
            PostInsertEventListener[] postInsertEventListenerArray = listeners;
            int n2 = postInsertEventListenerArray.length;
            for (n = 0; n < n2; ++n) {
                eventListener2 = postInsertEventListenerArray[n];
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length = listeners.length + 1;
                PostInsertEventListener[] newListeners = new PostInsertEventListener[length];
                System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                newListeners[length - 1] = (PostInsertEventListener)searchEventListener;
                eventListeners.setPostInsertEventListeners(newListeners);
            }
        } else {
            eventListeners.setPostInsertEventListeners(new PostInsertEventListener[]{(PostInsertEventListener)searchEventListener});
        }
        present = false;
        listeners = eventListeners.getPostUpdateEventListeners();
        if (listeners != null) {
            Serializable[] length = listeners;
            int newListeners = length.length;
            for (n = 0; n < newListeners; ++n) {
                eventListener2 = length[n];
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length2 = listeners.length + 1;
                PostUpdateEventListener[] newListeners2 = new PostUpdateEventListener[length2];
                System.arraycopy(listeners, 0, newListeners2, 0, length2 - 1);
                newListeners2[length2 - 1] = (PostUpdateEventListener)searchEventListener;
                eventListeners.setPostUpdateEventListeners(newListeners2);
            }
        } else {
            eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{(PostUpdateEventListener)searchEventListener});
        }
        present = false;
        listeners = eventListeners.getPostDeleteEventListeners();
        if (listeners != null) {
            Serializable[] length2 = listeners;
            int newListeners2 = length2.length;
            for (n = 0; n < newListeners2; ++n) {
                eventListener2 = length2[n];
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length = listeners.length + 1;
                PostDeleteEventListener[] newListeners = new PostDeleteEventListener[length];
                System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                newListeners[length - 1] = (PostDeleteEventListener)searchEventListener;
                eventListeners.setPostDeleteEventListeners(newListeners);
            }
        } else {
            eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[]{(PostDeleteEventListener)searchEventListener});
        }
        present = false;
        listeners = eventListeners.getPostCollectionRecreateEventListeners();
        if (listeners != null) {
            Serializable[] length = listeners;
            int newListeners = length.length;
            for (n = 0; n < newListeners; ++n) {
                eventListener2 = length[n];
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length3 = listeners.length + 1;
                PostCollectionRecreateEventListener[] newListeners3 = new PostCollectionRecreateEventListener[length3];
                System.arraycopy(listeners, 0, newListeners3, 0, length3 - 1);
                newListeners3[length3 - 1] = (PostCollectionRecreateEventListener)searchEventListener;
                eventListeners.setPostCollectionRecreateEventListeners(newListeners3);
            }
        } else {
            eventListeners.setPostCollectionRecreateEventListeners(new PostCollectionRecreateEventListener[]{(PostCollectionRecreateEventListener)searchEventListener});
        }
        present = false;
        listeners = eventListeners.getPostCollectionRemoveEventListeners();
        if (listeners != null) {
            Serializable[] length3 = listeners;
            int newListeners3 = length3.length;
            for (n = 0; n < newListeners3; ++n) {
                eventListener2 = length3[n];
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length = listeners.length + 1;
                PostCollectionRemoveEventListener[] newListeners = new PostCollectionRemoveEventListener[length];
                System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                newListeners[length - 1] = (PostCollectionRemoveEventListener)searchEventListener;
                eventListeners.setPostCollectionRemoveEventListeners(newListeners);
            }
        } else {
            eventListeners.setPostCollectionRemoveEventListeners(new PostCollectionRemoveEventListener[]{(PostCollectionRemoveEventListener)searchEventListener});
        }
        present = false;
        listeners = eventListeners.getPostCollectionUpdateEventListeners();
        if (listeners != null) {
            for (Serializable eventListener2 : listeners) {
                present = present || searchEventListenerClass == eventListener2.getClass();
            }
            if (!present) {
                int length = listeners.length + 1;
                PostCollectionUpdateEventListener[] newListeners = new PostCollectionUpdateEventListener[length];
                System.arraycopy(listeners, 0, newListeners, 0, length - 1);
                newListeners[length - 1] = (PostCollectionUpdateEventListener)searchEventListener;
                eventListeners.setPostCollectionUpdateEventListeners(newListeners);
            }
        } else {
            eventListeners.setPostCollectionUpdateEventListeners(new PostCollectionUpdateEventListener[]{(PostCollectionUpdateEventListener)searchEventListener});
        }
    }

    private static Class<?> attemptToLoadSearchEventListener() {
        Class searchEventListenerClass = null;
        try {
            searchEventListenerClass = ReflectHelper.classForName(FULL_TEXT_INDEX_EVENT_LISTENER_CLASS, HibernateSearchEventListenerRegister.class);
        }
        catch (ClassNotFoundException e) {
            log.debug("Search not present in classpath, ignoring event listener registration.");
        }
        return searchEventListenerClass;
    }

    private static Object instantiateEventListener(Class<?> clazz) {
        Object searchEventListener;
        try {
            searchEventListener = clazz.newInstance();
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to load Search event listener", e);
        }
        return searchEventListener;
    }
}

