/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdNioBackend;
import org.jrobin.core.SyncManager;

public class RrdNioBackendFactory
extends RrdFileBackendFactory {
    public static final int DEFAULT_SYNC_PERIOD = 300;
    private static SyncManager s_syncManager = new SyncManager(300);
    public static final String NAME = "NIO";

    public static int getSyncPeriod() {
        return s_syncManager.getSyncPeriod();
    }

    public static synchronized void setSyncPeriod(int syncPeriod) {
        s_syncManager.setSyncPeriod(syncPeriod);
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdNioBackend(path, readOnly, s_syncManager);
    }

    public void shutdown() {
        s_syncManager.shutdown();
    }

    @Override
    public String getFactoryName() {
        return NAME;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    SyncManager getSyncManager() {
        return s_syncManager;
    }
}

