/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.consumer.internal;

import com.eclipsesource.jaxrs.consumer.internal.RequestConfigurer;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class RequestError {
    private final String requestUrl;
    private final Response response;
    private final String method;
    private final String entity;

    public RequestError(RequestConfigurer configurer, Response response, String method) {
        this.response = response;
        this.method = method;
        this.requestUrl = configurer.getRequestUrl();
        this.entity = this.getInternalEntity();
    }

    public String getInternalEntity() {
        if (this.response.hasEntity()) {
            return (String)this.response.readEntity(String.class);
        }
        return null;
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Failed to send " + this.method + " request to: " + this.requestUrl);
        stringBuilder.append("\n");
        stringBuilder.append("Received Status: " + this.response.getStatus());
        if (this.entity != null) {
            stringBuilder.append("\nReceived Body: ");
            stringBuilder.append(this.entity);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getEntity() {
        return this.entity;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.response.getHeaders();
    }
}

