/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.commands;

import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.events.commands.EventUeiCompleter;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;

@Command(scope="opennms", name="event-list", description="Lists historical events meeting certain criteria")
@Service
public class EventListCommand
implements Action {
    @Reference
    public EventConfDao eventConfDao;
    @Reference
    public EventDao eventDao;
    @Option(name="-l", aliases={"--limit"}, description="Limit the number of events that are shown.")
    int limit = 10;
    @Argument(name="uei", description="Event UEI to match (exact).", required=false, multiValued=false)
    @Completion(value=EventUeiCompleter.class)
    String eventUeiMatch;

    public Object execute() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsEvent.class).orderBy("eventTime").desc().limit(Integer.valueOf(this.limit)).alias("node", "node", Alias.JoinType.LEFT_JOIN).alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        if (!Strings.isNullOrEmpty((String)this.eventUeiMatch)) {
            criteriaBuilder.eq("eventUei", (Object)this.eventUeiMatch);
        }
        OnmsEventCollection eventCollection = new OnmsEventCollection((Collection)this.eventDao.findMatching(criteriaBuilder.toCriteria()));
        eventCollection.setTotalCount(Integer.valueOf(this.eventDao.countMatching(criteriaBuilder.toCriteria())));
        System.out.println(String.format("Found %d events, showing %d:", eventCollection.getTotalCount(), eventCollection.size()));
        try {
            ShellTable table = new ShellTable();
            table.column("ID");
            table.column("UEI");
            table.column("Severity");
            table.column("Time");
            table.column("Node Label");
            table.column("Interface");
            table.column("Service");
            for (OnmsEvent event : eventCollection) {
                String ipAddr = "";
                if (event.getIpAddr() != null) {
                    ipAddr = event.getIpAddr().getHostAddress();
                }
                String serviceName = "";
                if (event.getServiceType() != null) {
                    serviceName = event.getServiceType().getName();
                }
                table.addRow().addContent(new Object[]{event.getId(), event.getEventUei(), event.getSeverityLabel(), event.getEventTime(), event.getNodeLabel(), ipAddr, serviceName});
            }
            table.print(System.out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
        return null;
    }
}

