/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.daemon;

import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.ipc.twin.api.TwinPublisher;
import org.opennms.netmgt.telemetry.daemon.LocationPublisher;
import org.springframework.beans.factory.annotation.Autowired;

public class LocationPublisherManager {
    @Autowired
    private TwinPublisher twinPublisher;
    private final ConcurrentHashMap<String, LocationPublisher> publishers = new ConcurrentHashMap();

    public LocationPublisher getOrCreate(String location) {
        return this.publishers.computeIfAbsent(location, loc -> new LocationPublisher((String)loc, this.twinPublisher));
    }

    public void removeIfEmpty(String location) {
        LocationPublisher lp = this.publishers.get(location);
        if (lp != null && !lp.hasConfigs()) {
            this.publishers.remove(location, lp);
        }
    }

    public void forceCloseAll() {
        this.publishers.forEach((loc, lp) -> lp.forceClose());
        this.publishers.clear();
    }
}

