/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.events.AttributeType;
import org.opennms.integration.api.v1.config.events.CollectionGroup;
import org.opennms.integration.api.v1.config.events.EventConfExtension;
import org.opennms.integration.api.v1.config.events.EventDefinition;
import org.opennms.integration.api.v1.config.events.LogMessage;
import org.opennms.integration.api.v1.config.events.LogMsgDestType;
import org.opennms.integration.api.v1.config.events.ManagedObject;
import org.opennms.integration.api.v1.config.events.MaskElement;
import org.opennms.integration.api.v1.config.events.Parameter;
import org.opennms.integration.api.v1.config.events.Varbind;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.dao.api.EventConfSourceDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.support.EventConfServiceHelper;
import org.opennms.netmgt.model.EventConfEvent;
import org.opennms.netmgt.model.EventConfSource;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.CollectionGroup;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.netmgt.xml.eventconf.Mask;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.UpdateField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfExtensionManager
extends ConfigExtensionManager<EventConfExtension, Events> {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfExtensionManager.class);
    static final String INTEGRATION_API_SOURCE_NAME = "opennms-plugins-events";
    private static final String USERNAME = "opennms-plugins";
    private final EventConfDao eventConfDao;
    private final EventConfSourceDao eventConfSourceDao;
    private final EventConfEventDao eventConfEventDao;
    private final SessionUtils sessionUtils;
    private final ExecutorService executor;
    private volatile EventConfSource pluginSource;

    public EventConfExtensionManager(EventConfDao eventConfDao, EventConfSourceDao eventConfSourceDao, EventConfEventDao eventConfEventDao, SessionUtils sessionUtils) {
        super(Events.class, new Events());
        this.eventConfDao = Objects.requireNonNull(eventConfDao);
        this.eventConfSourceDao = Objects.requireNonNull(eventConfSourceDao);
        this.eventConfEventDao = Objects.requireNonNull(eventConfEventDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.executor = EventConfServiceHelper.createEventConfExecutor((String)"integration-api-eventconf-%d");
        LOG.debug("EventConfExtensionManager initialized.");
    }

    @Override
    protected Events getConfigForExtensions(Set<EventConfExtension> extensions) {
        List<Event> orderedEvents = extensions.stream().flatMap(ext -> ext.getEventDefinitions().stream()).sorted(Comparator.comparing(EventDefinition::getPriority)).map(EventConfExtensionManager::toEvent).toList();
        Events events = new Events();
        events.getEvents().addAll(orderedEvents);
        return events;
    }

    @Override
    protected void triggerReload() {
        LOG.debug("Event configuration changed. Syncing to database and triggering reload.");
        boolean changesApplied = this.syncEventsToDatabase();
        if (changesApplied) {
            EventConfServiceHelper.reloadEventsFromDBAsync((EventConfEventDao)this.eventConfEventDao, (EventConfDao)this.eventConfDao, (ExecutorService)this.executor);
        } else {
            LOG.debug("No changes to sync, skipping reload.");
        }
    }

    protected synchronized boolean syncEventsToDatabase() {
        try {
            Events events = (Events)this.getObject();
            if (events == null || events.getEvents().isEmpty()) {
                LOG.debug("No events to persist from Integration API extensions.");
                return false;
            }
            return (Boolean)this.sessionUtils.withTransaction(() -> {
                boolean hasChanges;
                EventConfSource source = this.getOrCreatePluginSource();
                List dbEvents = this.eventConfEventDao.findBySourceId(source.getId());
                HashMap<String, List> dbEventsByUei = new HashMap<String, List>();
                for (EventConfEvent dbEvent : dbEvents) {
                    dbEventsByUei.computeIfAbsent(dbEvent.getUei(), k -> new ArrayList()).add(dbEvent);
                }
                List currentEvents = events.getEvents();
                Date now = new Date();
                ArrayList<Event> newEvents = new ArrayList<Event>();
                ArrayList<EventConfEvent> eventsToUpdate = new ArrayList<EventConfEvent>();
                for (Event currentEvent : currentEvents) {
                    EventConfEvent matchedDbEvent = null;
                    List candidatesWithSameUei = (List)dbEventsByUei.get(currentEvent.getUei());
                    if (candidatesWithSameUei != null) {
                        for (EventConfEvent dbEvent : candidatesWithSameUei) {
                            Event dbEventParsed = (Event)JaxbUtils.unmarshal(Event.class, (String)dbEvent.getXmlContent());
                            if (!EventConfServiceHelper.eventsMatch((Event)currentEvent, (Event)dbEventParsed)) continue;
                            matchedDbEvent = dbEvent;
                            break;
                        }
                    }
                    if (matchedDbEvent != null) {
                        String newXmlContent = JaxbUtils.marshal((Object)currentEvent);
                        if (newXmlContent.equals(matchedDbEvent.getXmlContent())) continue;
                        matchedDbEvent.setEventLabel(currentEvent.getEventLabel());
                        matchedDbEvent.setDescription(currentEvent.getDescr());
                        matchedDbEvent.setXmlContent(newXmlContent);
                        matchedDbEvent.setLastModified(now);
                        matchedDbEvent.setModifiedBy(USERNAME);
                        eventsToUpdate.add(matchedDbEvent);
                        continue;
                    }
                    newEvents.add(currentEvent);
                }
                ArrayList<EventConfEvent> allEventsToSave = new ArrayList<EventConfEvent>();
                if (!newEvents.isEmpty()) {
                    List newEntities = EventConfServiceHelper.createEventConfEventEntities((EventConfSource)source, newEvents, (String)USERNAME, (Date)now);
                    allEventsToSave.addAll(newEntities);
                }
                allEventsToSave.addAll(eventsToUpdate);
                boolean bl = hasChanges = !allEventsToSave.isEmpty();
                if (hasChanges) {
                    this.eventConfEventDao.saveAll(allEventsToSave);
                    LOG.info("Synced {} events to Integration API source ({} new, {} updated)", new Object[]{allEventsToSave.size(), newEvents.size(), eventsToUpdate.size()});
                    int totalCount = this.eventConfEventDao.countBySourceId(source.getId());
                    source.setEventCount(Integer.valueOf(totalCount));
                    source.setLastModified(new Date());
                    this.eventConfSourceDao.saveOrUpdate(source);
                    LOG.info("Synced Integration API events to database: {} total events in source '{}'", (Object)totalCount, (Object)INTEGRATION_API_SOURCE_NAME);
                } else {
                    LOG.debug("No changes to Integration API events");
                }
                return hasChanges;
            });
        }
        catch (Exception e) {
            LOG.error("Failed to sync Integration API events to database", (Throwable)e);
            return false;
        }
    }

    private EventConfSource getOrCreatePluginSource() {
        EventConfSource source = this.eventConfSourceDao.findByName(INTEGRATION_API_SOURCE_NAME);
        if (source == null) {
            source = new EventConfSource();
            Date now = new Date();
            source.setName(INTEGRATION_API_SOURCE_NAME);
            source.setDescription("Events from OpenNMS plugins");
            source.setVendor("OpenNMS-Plugins");
            source.setEnabled(Boolean.valueOf(true));
            Integer maxFileOrder = this.eventConfSourceDao.findMaxFileOrder();
            source.setFileOrder(Integer.valueOf(maxFileOrder != null ? maxFileOrder + 1 : 1));
            source.setCreatedTime(now);
            source.setLastModified(now);
            source.setUploadedBy(USERNAME);
            source.setEventCount(Integer.valueOf(0));
            this.eventConfSourceDao.save((Object)source);
            LOG.info("Created new EventConfSource: {} with fileOrder: {}", (Object)INTEGRATION_API_SOURCE_NAME, (Object)source.getFileOrder());
        }
        this.pluginSource = source;
        return source;
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private static Event toEvent(EventDefinition def) {
        Event event = new Event();
        event.setMask(EventConfExtensionManager.toMask(def.getMask()));
        event.setUei(def.getUei());
        event.setPriority(Integer.valueOf(def.getPriority()));
        event.setEventLabel(def.getLabel());
        event.setDescr(def.getDescription());
        event.setSeverity(def.getSeverity().getLabel());
        event.setLogmsg(EventConfExtensionManager.toLogMsg(def.getLogMessage()));
        event.setOperinstruct(def.getOperatorInstructions());
        event.setAlarmData(EventConfExtensionManager.toAlarmData(def.getAlarmData()));
        List parms = def.getParameters().stream().map(EventConfExtensionManager::toParameter).collect(Collectors.toList());
        event.setParameters(parms);
        event.setCollectionGroup(def.getCollectionGroup().stream().map(EventConfExtensionManager::toCollectionGroup).collect(Collectors.toList()));
        return event;
    }

    private static Logmsg toLogMsg(LogMessage l) {
        Logmsg logmsg = new Logmsg();
        logmsg.setContent(l.getContent());
        logmsg.setDest(EventConfExtensionManager.toLogDestType(l.getDestination()));
        return logmsg;
    }

    private static LogDestType toLogDestType(LogMsgDestType type) {
        if (type != null) {
            switch (type) {
                case LOGNDISPLAY: {
                    return LogDestType.LOGNDISPLAY;
                }
                case DISPLAYONLY: {
                    return LogDestType.DISPLAYONLY;
                }
                case LOGONLY: {
                    return LogDestType.LOGONLY;
                }
                case SUPPRESS: {
                    return LogDestType.SUPPRESS;
                }
                case DONOTPERSIST: {
                    return LogDestType.DONOTPERSIST;
                }
                case DISCARDTRAPS: {
                    return LogDestType.DISCARDTRAPS;
                }
            }
        }
        return LogDestType.LOGNDISPLAY;
    }

    private static Mask toMask(org.opennms.integration.api.v1.config.events.Mask m) {
        if (m == null) {
            return null;
        }
        Mask mask = new Mask();
        mask.setMaskelements(m.getMaskElements().stream().map(EventConfExtensionManager::toMaskElement).collect(Collectors.toList()));
        mask.setVarbinds(m.getVarbinds().stream().map(EventConfExtensionManager::toVarbind).collect(Collectors.toList()));
        return mask;
    }

    private static Maskelement toMaskElement(MaskElement el) {
        Maskelement maskEl = new Maskelement();
        maskEl.setMename(el.getName());
        maskEl.setMevalues(el.getValues());
        return maskEl;
    }

    private static org.opennms.netmgt.xml.eventconf.Varbind toVarbind(Varbind vb) {
        org.opennms.netmgt.xml.eventconf.Varbind varbind = new org.opennms.netmgt.xml.eventconf.Varbind();
        varbind.setVbnumber(vb.getNumber());
        varbind.setTextualConvention(vb.getTextualConvention());
        varbind.setVbvalues(vb.getValues());
        return varbind;
    }

    private static AlarmData toAlarmData(org.opennms.integration.api.v1.config.events.AlarmData alarm) {
        if (alarm == null) {
            return null;
        }
        AlarmData alarmData = new AlarmData();
        alarmData.setReductionKey(alarm.getReductionKey());
        alarmData.setClearKey(alarm.getClearKey());
        if (alarm.getType() != null) {
            alarmData.setAlarmType(Integer.valueOf(alarm.getType().getId()));
        }
        alarmData.setAutoClean(Boolean.valueOf(alarm.isAutoClean()));
        List updateFields = alarm.getUpdateFields().stream().map(EventConfExtensionManager::toUpdateField).collect(Collectors.toList());
        alarmData.setUpdateFields(updateFields);
        alarmData.setManagedObject(EventConfExtensionManager.toManagedObject(alarm.getManagedObject()));
        return alarmData;
    }

    private static UpdateField toUpdateField(org.opennms.integration.api.v1.config.events.UpdateField u) {
        UpdateField updateField = new UpdateField();
        updateField.setFieldName(u.getName());
        updateField.setUpdateOnReduction(Boolean.valueOf(u.isUpdatedOnReduction()));
        return updateField;
    }

    private static org.opennms.netmgt.xml.eventconf.Parameter toParameter(Parameter p) {
        org.opennms.netmgt.xml.eventconf.Parameter parm = new org.opennms.netmgt.xml.eventconf.Parameter();
        parm.setName(p.getName());
        parm.setValue(p.getValue());
        parm.setExpand(Boolean.valueOf(p.shouldExpand()));
        return parm;
    }

    private static org.opennms.netmgt.xml.eventconf.ManagedObject toManagedObject(ManagedObject mo) {
        if (mo == null) {
            return null;
        }
        org.opennms.netmgt.xml.eventconf.ManagedObject managedObject = new org.opennms.netmgt.xml.eventconf.ManagedObject();
        managedObject.setType(mo.getType());
        return managedObject;
    }

    private static org.opennms.netmgt.xml.eventconf.CollectionGroup toCollectionGroup(CollectionGroup apiCollectionGroup) {
        if (apiCollectionGroup == null) {
            return null;
        }
        org.opennms.netmgt.xml.eventconf.CollectionGroup collectionGroup = new org.opennms.netmgt.xml.eventconf.CollectionGroup();
        collectionGroup.setName(apiCollectionGroup.getName());
        collectionGroup.setInstance(apiCollectionGroup.getInstance());
        collectionGroup.setResourceType(apiCollectionGroup.getResourceType());
        collectionGroup.setRrd(EventConfExtensionManager.toRrd(apiCollectionGroup.getRrd()));
        collectionGroup.setCollection(apiCollectionGroup.getCollection().stream().map(EventConfExtensionManager::toCollection).collect(Collectors.toList()));
        return collectionGroup;
    }

    private static CollectionGroup.Rrd toRrd(CollectionGroup.Rrd apiRrd) {
        if (apiRrd == null) {
            return null;
        }
        CollectionGroup.Rrd rrd = new CollectionGroup.Rrd();
        rrd.setRras(apiRrd.getRras());
        rrd.setHeartBeat(apiRrd.getHeartBeat());
        rrd.setStep(apiRrd.getStep());
        return rrd;
    }

    private static CollectionGroup.Collection toCollection(CollectionGroup.Collection apiCollection) {
        if (apiCollection == null) {
            return null;
        }
        CollectionGroup.Collection collection = new CollectionGroup.Collection();
        collection.setName(apiCollection.getName());
        collection.setType(EventConfExtensionManager.toAttributeType(apiCollection.getType()));
        collection.setParamValue(apiCollection.getParamValue().stream().map(EventConfExtensionManager::toParamValue).collect(Collectors.toList()));
        collection.setRename(apiCollection.getRename());
        return collection;
    }

    private static org.opennms.netmgt.collection.api.AttributeType toAttributeType(AttributeType type) {
        if (type != null) {
            switch (type) {
                case GAUGE: {
                    return org.opennms.netmgt.collection.api.AttributeType.GAUGE;
                }
                case COUNTER: {
                    return org.opennms.netmgt.collection.api.AttributeType.COUNTER;
                }
                case STRING: {
                    return org.opennms.netmgt.collection.api.AttributeType.STRING;
                }
            }
        }
        return org.opennms.netmgt.collection.api.AttributeType.GAUGE;
    }

    private static CollectionGroup.ParamValue toParamValue(CollectionGroup.ParamValue apiParamValue) {
        if (apiParamValue == null) {
            return null;
        }
        CollectionGroup.ParamValue paramValue = new CollectionGroup.ParamValue();
        paramValue.setName(apiParamValue.getName());
        paramValue.setValue(apiParamValue.getValue());
        return paramValue;
    }
}

