/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.application;

import java.util.Objects;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphProvider;
import org.opennms.netmgt.graph.domain.AbstractDomainEdge;
import org.opennms.netmgt.graph.domain.simple.SimpleDomainEdge;
import org.opennms.netmgt.graph.provider.application.ApplicationGraph;
import org.opennms.netmgt.graph.provider.application.ApplicationVertex;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;

public class ApplicationGraphProvider
implements GraphProvider {
    private static final String GRAPH_LABEL = "Application Graph";
    private static final String GRAPH_DESCRIPTION = "Displays all defined applications and their calculated states.";
    private final ApplicationDao applicationDao;
    private final SessionUtils sessionUtils;

    public ApplicationGraphProvider(SessionUtils sessionUtils, ApplicationDao applicationDao) {
        Objects.requireNonNull(applicationDao);
        Objects.requireNonNull(sessionUtils);
        this.applicationDao = applicationDao;
        this.sessionUtils = sessionUtils;
    }

    public GraphInfo getGraphInfo() {
        DefaultGraphInfo graphInfo = new DefaultGraphInfo("application");
        graphInfo.setLabel(GRAPH_LABEL);
        graphInfo.setDescription(GRAPH_DESCRIPTION);
        return graphInfo;
    }

    public ImmutableGraph<ApplicationVertex, SimpleDomainEdge> loadGraph() {
        return (ImmutableGraph)this.sessionUtils.withReadOnlyTransaction(() -> {
            ApplicationGraph.ApplicationGraphBuilder graphBuilder = ((ApplicationGraph.ApplicationGraphBuilder)ApplicationGraph.builder().label(GRAPH_LABEL)).description(GRAPH_DESCRIPTION);
            for (OnmsApplication application : this.applicationDao.findAll()) {
                ApplicationVertex applicationVertex = ApplicationVertex.builder().application(application).build();
                graphBuilder.addVertex(applicationVertex);
                for (OnmsMonitoredService eachMonitoredService : application.getMonitoredServices()) {
                    ApplicationVertex serviceVertex = ApplicationVertex.builder().service(eachMonitoredService).build();
                    graphBuilder.addVertex(serviceVertex);
                    SimpleDomainEdge edge = ((SimpleDomainEdge.SimpleDomainEdgeBuilder)((SimpleDomainEdge.SimpleDomainEdgeBuilder)((SimpleDomainEdge.SimpleDomainEdgeBuilder)SimpleDomainEdge.builder().namespace("application")).source(applicationVertex.getVertexRef())).target(serviceVertex.getVertexRef())).build();
                    graphBuilder.addEdge((AbstractDomainEdge)edge);
                }
            }
            return graphBuilder.build();
        });
    }
}

