/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.jasperreports.compiler;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.apache.commons.io.FileUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;

public class ReportCompiler {
    private static void initializeSingleInstanceDatabase() {
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
            DataSourceConfiguration dsc = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (File)cfgFile);
            boolean found = false;
            for (JdbcDataSource jds : dsc.getJdbcDataSourceCollection()) {
                if (!jds.getName().equals("opennms")) continue;
                System.out.printf("Initializing datatabase %s\n", jds.getUrl());
                DataSourceFactory.setInstance((DataSource)new SimpleDataSource(jds));
                found = true;
            }
            if (!found) {
                System.err.printf("Error: Can't find OpenNMS database configuration.\n", new Object[0]);
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.printf("Error: Can't initialize OpenNMS database connection factory. %s\n", e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length > 1 && new File(args[0]).exists()) {
            System.setProperty("opennms.home", args[0]);
        }
        ReportCompiler.initializeSingleInstanceDatabase();
        BeanUtils.getBeanFactory((String)"jasperReportContext");
        File reportsDirectory = new File(ConfigFileConstants.getFilePathString(), "report-templates");
        System.out.printf("Analyzing jasper reports located at %s\n", reportsDirectory);
        for (File report : FileUtils.listFiles((File)reportsDirectory, (String[])new String[]{"jrxml"}, (boolean)true)) {
            System.out.printf("Compiling report template %s\n", report.getAbsolutePath());
            try {
                JasperCompileManager.compileReportToFile((String)report.getAbsolutePath());
            }
            catch (JRException e) {
                System.err.println("Error: cannot compile report because: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static class SimpleDataSource
    implements DataSource {
        private String m_driver;
        private String m_url;
        private Properties m_properties = new Properties();
        private Integer m_timeout = null;

        public SimpleDataSource(JdbcDataSource ds) throws ClassNotFoundException {
            this.m_driver = ds.getClassName();
            this.m_url = ds.getUrl();
            this.m_properties.put("user", ds.getUserName());
            this.m_properties.put("password", ds.getPassword());
            Class.forName(this.m_driver);
            for (Param param : ds.getParamCollection()) {
                this.m_properties.put(param.getName(), param.getValue());
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.m_timeout == null) {
                return DriverManager.getConnection(this.m_url, this.m_properties);
            }
            int oldTimeout = DriverManager.getLoginTimeout();
            DriverManager.setLoginTimeout(this.m_timeout);
            Connection conn = DriverManager.getConnection(this.m_url, this.m_properties);
            DriverManager.setLoginTimeout(oldTimeout);
            return conn;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException("getConnection(String, String) not implemented");
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException("getLogWriter() not implemented");
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.m_timeout == null ? -1 : this.m_timeout;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException("setLogWriter(PrintWriter) not implemented");
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.m_timeout = seconds;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("getParentLogger not supported");
        }
    }
}

