/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.telemetry.config.model.PackageConfig;
import org.opennms.netmgt.telemetry.distributed.common.PropertyTree;

public class MapBasedAdapterDef
implements AdapterDefinition {
    private final String queueName;
    private final String name;
    private final String className;
    private final Map<String, String> parameters;

    public MapBasedAdapterDef(String queueName, PropertyTree definition) {
        this.queueName = queueName;
        this.name = definition.getRequiredString("name");
        this.className = definition.getRequiredString("class-name");
        this.parameters = definition.getFlatMap("parameters");
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return String.format("%s.%s", this.queueName, this.getName());
    }

    public List<? extends PackageDefinition> getPackages() {
        ArrayList arrayList;
        block8: {
            InputStream inputStream = this.getClass().getResourceAsStream("/package.xml");
            try {
                PackageConfig pkg = (PackageConfig)JaxbUtils.unmarshal(PackageConfig.class, (InputStream)inputStream);
                arrayList = Lists.newArrayList((Object[])new PackageConfig[]{pkg});
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while reading package.xml", e);
                }
            }
            inputStream.close();
        }
        return arrayList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedAdapterDef that = (MapBasedAdapterDef)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.parameters);
    }
}

