/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Properties;
import org.dhcp4java.DHCPBadPacketException;
import org.dhcp4java.DHCPCoreServer;
import org.dhcp4java.DHCPPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHCPServlet {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DHCPServlet.class);
    protected DHCPCoreServer m_aServer;

    public void init(Properties properties) {
    }

    public DatagramPacket serviceDatagram(DatagramPacket datagramPacket) {
        if (datagramPacket == null) {
            return null;
        }
        try {
            DHCPPacket dHCPPacket = DHCPPacket.getPacket(datagramPacket);
            if (dHCPPacket == null) {
                return null;
            }
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug(dHCPPacket.toString());
            }
            DHCPPacket dHCPPacket2 = this.service(dHCPPacket);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("service() done");
            }
            if (dHCPPacket2 == null) {
                return null;
            }
            InetAddress inetAddress = dHCPPacket2.getAddress();
            if (inetAddress == null) {
                s_aLogger.warn("Address needed in response");
                return null;
            }
            int n = dHCPPacket2.getPort();
            byte[] byArray = dHCPPacket2.serialize();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Buffer is " + byArray.length + " bytes long");
            }
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Sending back to" + inetAddress.getHostAddress() + '(' + n + ')');
            }
            this.postProcess(datagramPacket, datagramPacket2);
            return datagramPacket2;
        }
        catch (DHCPBadPacketException dHCPBadPacketException) {
            s_aLogger.info("Invalid DHCP packet received", (Throwable)dHCPBadPacketException);
        }
        catch (Exception exception) {
            s_aLogger.info("Unexpected Exception", (Throwable)exception);
        }
        return null;
    }

    protected DHCPPacket service(DHCPPacket dHCPPacket) {
        if (dHCPPacket == null) {
            return null;
        }
        if (!dHCPPacket.isDhcp()) {
            s_aLogger.info("BOOTP packet rejected");
            return null;
        }
        Byte by = dHCPPacket.getDHCPMessageType();
        if (by == null) {
            s_aLogger.info("no DHCP message type");
            return null;
        }
        if (dHCPPacket.getOp() == 1) {
            switch (by) {
                case 1: {
                    return this.doDiscover(dHCPPacket);
                }
                case 3: {
                    return this.doRequest(dHCPPacket);
                }
                case 8: {
                    return this.doInform(dHCPPacket);
                }
                case 4: {
                    return this.doDecline(dHCPPacket);
                }
                case 7: {
                    return this.doRelease(dHCPPacket);
                }
            }
            s_aLogger.info("Unsupported message type " + by);
            return null;
        }
        if (dHCPPacket.getOp() == 2) {
            s_aLogger.info("BOOTREPLY received from client");
            return null;
        }
        s_aLogger.warn("Unknown Op: " + dHCPPacket.getOp());
        return null;
    }

    protected DHCPPacket doDiscover(DHCPPacket dHCPPacket) {
        s_aLogger.info("DISCOVER packet received");
        return null;
    }

    protected DHCPPacket doRequest(DHCPPacket dHCPPacket) {
        s_aLogger.info("REQUEST packet received");
        return null;
    }

    protected DHCPPacket doInform(DHCPPacket dHCPPacket) {
        s_aLogger.info("INFORM packet received");
        return null;
    }

    protected DHCPPacket doDecline(DHCPPacket dHCPPacket) {
        s_aLogger.info("DECLINE packet received");
        return null;
    }

    protected DHCPPacket doRelease(DHCPPacket dHCPPacket) {
        s_aLogger.info("RELEASE packet received");
        return null;
    }

    protected void postProcess(DatagramPacket datagramPacket, DatagramPacket datagramPacket2) {
    }

    public DHCPCoreServer getServer() {
        return this.m_aServer;
    }

    public void setServer(DHCPCoreServer dHCPCoreServer) {
        this.m_aServer = dHCPCoreServer;
    }
}

