/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.client.rpc;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.mate.api.FallbackScope;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.MapScope;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.core.rpc.api.RpcTarget;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.PollerRequestBuilder;
import org.opennms.netmgt.poller.PollerResponse;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.poller.client.rpc.LocationAwarePollerClientImpl;
import org.opennms.netmgt.poller.client.rpc.PollerRequestDTO;

public class PollerRequestBuilderImpl
implements PollerRequestBuilder {
    private MonitoredService service;
    private String systemId;
    private String className;
    private LocationAwarePollerClientImpl client;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<ServiceMonitorAdaptor> adaptors = new LinkedList<ServiceMonitorAdaptor>();
    private final Map<String, String> patternVariables = new HashMap<String, String>();
    private Long ttlInMs;

    public PollerRequestBuilderImpl(LocationAwarePollerClientImpl client) {
        this.client = client;
    }

    public PollerRequestBuilder withService(MonitoredService service) {
        this.service = service;
        return this;
    }

    public PollerRequestBuilder withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    public PollerRequestBuilder withMonitorLocator(ServiceMonitorLocator serviceMonitorLocator) {
        return this.withMonitorClassName(serviceMonitorLocator.getServiceLocatorKey());
    }

    public PollerRequestBuilder withMonitorClassName(String className) {
        this.className = className;
        return this;
    }

    public PollerRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public PollerRequestBuilder withAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public PollerRequestBuilder withAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public PollerRequestBuilder withAdaptor(ServiceMonitorAdaptor adaptor) {
        this.adaptors.add(adaptor);
        return this;
    }

    public PollerRequestBuilder withPatternVariables(Map<String, String> patternVariables) {
        this.patternVariables.putAll(patternVariables);
        return this;
    }

    private Scope getScope() {
        return new FallbackScope(new Scope[]{this.client.getEntityScopeProvider().getScopeForNode(Integer.valueOf(this.service.getNodeId())), this.client.getEntityScopeProvider().getScopeForInterface(Integer.valueOf(this.service.getNodeId()), this.service.getIpAddr()), this.client.getEntityScopeProvider().getScopeForService(Integer.valueOf(this.service.getNodeId()), this.service.getAddress(), this.service.getSvcName()), MapScope.singleContext((Scope.ScopeName)Scope.ScopeName.SERVICE, (String)"pattern", this.patternVariables)});
    }

    public Map<String, Object> getInterpolatedAttributes() {
        return Interpolator.interpolateObjects(this.attributes, (Scope)this.getScope());
    }

    public CompletableFuture<PollerResponse> execute() {
        if (this.className == null) {
            throw new IllegalArgumentException("Monitor class name is required.");
        }
        if (this.service == null) {
            throw new IllegalArgumentException("Monitored service is required.");
        }
        ServiceMonitor serviceMonitor = this.client.getRegistry().getMonitorByClassName(this.className);
        if (serviceMonitor == null) {
            throw new IllegalArgumentException("Monitor not found: " + this.className);
        }
        Map<String, Object> interpolatedAttributes = this.getInterpolatedAttributes();
        RpcTarget target = this.client.getRpcTargetHelper().target().withNodeId(Integer.valueOf(this.service.getNodeId())).withLocation(this.service.getNodeLocation()).withSystemId(this.systemId).withServiceAttributes(interpolatedAttributes).withLocationOverride(s -> serviceMonitor.getEffectiveLocation(s)).build();
        PollerRequestDTO request = new PollerRequestDTO();
        request.setLocation(target.getLocation());
        request.setSystemId(target.getSystemId());
        request.setClassName(this.className);
        request.setServiceName(this.service.getSvcName());
        request.setAddress(this.service.getAddress());
        request.setNodeId(this.service.getNodeId());
        request.setNodeLabel(this.service.getNodeLabel());
        request.setNodeLocation(this.service.getNodeLocation());
        this.ttlInMs = ParameterMap.getLongValue((String)"ttl", (Object)interpolatedAttributes.get("ttl"), (Long)this.ttlInMs);
        request.setTimeToLiveMs(this.ttlInMs);
        request.addAttributes(interpolatedAttributes);
        request.addTracingInfo("nodeId", String.valueOf(this.service.getNodeId()));
        request.addTracingInfo("nodeLabel", this.service.getNodeLabel());
        request.addTracingInfo("className", this.className);
        request.addTracingInfo("ipAddress", InetAddressUtils.toIpAddrString((InetAddress)this.service.getAddress()));
        Map<String, Object> parameters = request.getMonitorParameters();
        request.addAttributes(Interpolator.interpolateAttributes((Map)serviceMonitor.getRuntimeAttributes((MonitoredService)request, parameters), (Scope)this.getScope()));
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(results -> {
            PollStatus pollStatus = results.getPollStatus();
            for (ServiceMonitorAdaptor adaptor : this.adaptors) {
                pollStatus = adaptor.handlePollResult(this.service, new HashMap(interpolatedAttributes), pollStatus);
            }
            results.setPollStatus(pollStatus);
            return results;
        });
    }
}

