/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.IRandom;
import java.util.Map;

public abstract class BasePRNG
implements IRandom {
    protected String name;
    protected boolean initialised;
    protected byte[] buffer;
    protected int ndx;

    protected BasePRNG(String name) {
        this.name = name;
        this.initialised = false;
        this.buffer = new byte[0];
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(Map attributes) {
        this.setup(attributes);
        this.ndx = 0;
        this.initialised = true;
    }

    @Override
    public byte nextByte() {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return this.nextByteInternal();
    }

    @Override
    public void nextBytes(byte[] out, int offset, int length) {
        if (out == null) {
            return;
        }
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        if (offset < 0 || offset >= out.length || length < 1) {
            return;
        }
        int limit = offset + length > out.length ? out.length - offset : length;
        for (int i = 0; i < limit; ++i) {
            out[offset++] = this.nextByteInternal();
        }
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    private byte nextByteInternal() {
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        return this.buffer[this.ndx++];
    }

    @Override
    public abstract Object clone();

    public abstract void setup(Map var1);

    public abstract void fillBlock();
}

