/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.commands;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.commands.CmdRunException;
import org.opennms.features.jmxconfiggenerator.commands.Command;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.jmxconfiggenerator.graphs.Report;

public class GraphCreateCommand
extends Command {
    @Option(name="--input", usage="Jmx-datacolletion.xml file to use as input to generate the graph properties file", metaVar="<jmx-datacollection.xml>")
    private String inputFile;
    @Option(name="--output", usage="File name for the generated graph properties file.", required=false, metaVar="<file>")
    private String outFile;
    @Option(name="--template", usage="Template file using Apache Velocity template engine to be used to generate the graph properties. Use --print-template to print the default template", required=false, metaVar="<file>")
    private String templateFile;
    @Option(name="--print-template", usage="Prints the default template.", required=false)
    private boolean printTemplate;

    @Override
    protected void execute() throws CmdRunException, CmdLineException {
        if (this.printTemplate) {
            this.LOG.info(this.getClass().getResourceAsStream("/graphTemplate.vm"));
            return;
        }
        try {
            JmxConfigReader jmxToSnmpGraphConfigGen = new JmxConfigReader(this.LOG);
            Collection<Report> reports = jmxToSnmpGraphConfigGen.generateReportsByJmxDatacollectionConfig(this.inputFile);
            GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator(this.LOG);
            String snmpGraphConfig = graphConfigGenerator.generateSnmpGraph(reports, this.templateFile);
            this.LOG.info(snmpGraphConfig, new Object[0]);
            ByteStreams.copy((InputStream)new ByteArrayInputStream(snmpGraphConfig.getBytes()), (OutputStream)new FileOutputStream(this.outFile));
        }
        catch (IOException ioex) {
            throw new CmdRunException(ioex);
        }
    }

    @Override
    protected String getDescription() {
        return "Generates the snmp-graph.properties file.";
    }

    @Override
    protected void validate(CmdLineParser parser) throws CmdLineException {
        if (this.printTemplate) {
            return;
        }
        if (this.inputFile == null) {
            throw new CmdLineException(this.getParser(), "You have not specified an input file.");
        }
        if (!Files.exists(Paths.get(this.inputFile, new String[0]), new LinkOption[0])) {
            throw new CmdLineException(this.getParser(), "You have specified an input file which does not exist.");
        }
        if (this.outFile == null) {
            this.LOG.warn("No output file name defined using: snmp-graph.properties", new Object[0]);
            this.outFile = "snmp-graph.properties";
        }
        if (Files.exists(Paths.get(this.outFile, new String[0]), new LinkOption[0])) {
            throw new CmdLineException("The specified outfile already exists.");
        }
        if (this.templateFile != null && !Files.exists(Paths.get(this.templateFile, new String[0]), new LinkOption[0])) {
            throw new CmdLineException("The specified template file does not exist.");
        }
    }
}

