/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator;

import java.io.PrintStream;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommandHandler;
import org.kohsuke.args4j.spi.SubCommands;
import org.opennms.features.jmxconfiggenerator.commands.CmdRunException;
import org.opennms.features.jmxconfiggenerator.commands.Command;
import org.opennms.features.jmxconfiggenerator.commands.GraphCreateCommand;
import org.opennms.features.jmxconfiggenerator.commands.JmxConfigCreateCommand;
import org.opennms.features.jmxconfiggenerator.commands.QueryCommand;
import org.opennms.features.jmxconfiggenerator.log.ConsoleLogAdapter;

public class Starter
extends Command {
    @Argument(handler=SubCommandHandler.class, usage="These are the supported commands. Type JmxConfigGenerator <command> --help for more details.", metaVar="<command>", required=false)
    @SubCommands(value={@SubCommand(name="query", impl=QueryCommand.class), @SubCommand(name="generate-conf", impl=JmxConfigCreateCommand.class), @SubCommand(name="generate-graph", impl=GraphCreateCommand.class)})
    private Command cmd;

    public static void main(String[] args) {
        Starter starter = new Starter();
        CmdLineParser parser = new CmdLineParser((Object)starter, ParserProperties.defaults().withUsageWidth(120));
        try {
            parser.parseArgument(args);
            if (starter.cmd == null) {
                starter.cmd = starter;
            }
            starter.cmd.run(parser);
        }
        catch (CmdLineException e) {
            starter.LOG.error(e.getMessage(), new Object[0]);
            starter.LOG.error("", new Object[0]);
            starter.cmd.printUsage();
            System.exit(1);
        }
        catch (CmdRunException ex) {
            Starter.handleException(ex, starter.LOG);
            System.exit(2);
        }
        catch (Exception e) {
            Starter.handleException(e, starter.LOG);
            System.exit(3);
        }
    }

    protected static void handleException(Exception ex, ConsoleLogAdapter logAdapter) {
        logAdapter.error("An unexpected error occurred.", new Object[0]);
        logAdapter.error(ex.getMessage(), new Object[0]);
        if (logAdapter.isDebugEnabled()) {
            ex.printStackTrace(new PrintStream(logAdapter.getErrorOutputStream()));
        }
        if (ex.getCause() != null) {
            logAdapter.error("{}: {}", ex.getCause(), ex.getCause().getMessage());
            if (logAdapter.isDebugEnabled()) {
                ex.getCause().printStackTrace(new PrintStream(logAdapter.getErrorOutputStream()));
            }
        }
    }

    @Override
    protected void execute() throws CmdRunException, CmdLineException {
        if (!this.isHelp() && this.cmd == this) {
            this.printUsage();
        }
    }

    @Override
    protected void validate(CmdLineParser parser) throws CmdLineException {
    }

    @Override
    protected String getDescription() {
        return "JmxConfigGenerator <command> [options...] [arguments...]";
    }

    @Override
    public void printUsage() {
        super.printUsage();
        this.LOG.info("", new Object[0]);
        this.LOG.info("Examples: ", new Object[0]);
        this.LOG.info(" Querying: java-jar JmxConfigGenerator.jar query --host localhost --port 7199 [--ids-only] [--show-domains] [--ignore <filter criteria>] [--include-values] <filter criteria>", new Object[0]);
        this.LOG.info(" Generation of jmx-datacollection.xml: java -jar JmxConfigGenerator.jar generate-conf --host localhost --port 7199 --output JMX-DatacollectionDummy.xml [--service cassandra] [--skipDefaultVM] [--dictionary dictionary.properties]", new Object[0]);
        this.LOG.info(" Generation of snmp-graph.properties: java -jar JmxConfigGenerator.jar generate-graph --input test.xml --output test.properties [--template graphTemplate.vm]", new Object[0]);
    }
}

