/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPReferralHandler;
import java.util.Hashtable;

public class LDAPSearchConstraints
extends LDAPConstraints {
    private int dereference = 0;
    private int serverTimeLimit = 0;
    private int maxResults = 1000;
    private int batchSize = 1;
    private static Object nameLock = new Object();
    private static int lSConsNum = 0;
    private String name;
    public static final int DEREF_NEVER = 0;
    public static final int DEREF_SEARCHING = 1;
    public static final int DEREF_FINDING = 2;
    public static final int DEREF_ALWAYS = 3;

    public LDAPSearchConstraints() {
    }

    public LDAPSearchConstraints(LDAPConstraints lDAPConstraints) {
        super(lDAPConstraints.getTimeLimit(), lDAPConstraints.getReferralFollowing(), lDAPConstraints.getReferralHandler(), lDAPConstraints.getHopLimit());
        Hashtable hashtable;
        LDAPControl[] lDAPControlArray = lDAPConstraints.getControls();
        if (lDAPControlArray != null) {
            super.setControls((LDAPControl[])lDAPControlArray.clone());
        }
        if ((hashtable = lDAPConstraints.getProperties()) != null) {
            super.setProperties((Hashtable)hashtable.clone());
        }
        if (lDAPConstraints instanceof LDAPSearchConstraints) {
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConstraints;
            this.serverTimeLimit = lDAPSearchConstraints.getServerTimeLimit();
            this.dereference = lDAPSearchConstraints.getDereference();
            this.maxResults = lDAPSearchConstraints.getMaxResults();
            this.batchSize = lDAPSearchConstraints.getBatchSize();
        }
    }

    public LDAPSearchConstraints(int n, int n2, int n3, int n4, boolean bl, int n5, LDAPReferralHandler lDAPReferralHandler, int n6) {
        super(n, bl, lDAPReferralHandler, n6);
        this.serverTimeLimit = n2;
        this.dereference = n3;
        this.maxResults = n4;
        this.batchSize = n5;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getDereference() {
        return this.dereference;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public void setDereference(int n) {
        this.dereference = n;
    }

    public void setMaxResults(int n) {
        this.maxResults = n;
    }

    public void setServerTimeLimit(int n) {
        this.serverTimeLimit = n;
    }
}

