/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.test;

import org.extremecomponents.test.TableParameters;

public class ExtremeTableTestHelper {
    private TableParameters parameters;
    private String prefixWithTableId;

    public ExtremeTableTestHelper(TableParameters parameters) {
        this(parameters, "ec");
    }

    public ExtremeTableTestHelper(TableParameters parameters, String tableId) {
        this.parameters = parameters;
        this.prefixWithTableId = tableId + "_";
        parameters.addParameter("ec_eti", tableId);
    }

    public void addFilter(String property, String value) {
        this.parameters.addParameter(this.getFilter(property), value);
    }

    public void addPage(int page) {
        this.parameters.addParameter(this.prefixWithTableId + "p", String.valueOf(page));
    }

    public void addSortAsc(String property) {
        this.parameters.addParameter(this.prefixWithTableId + "s_" + property, "asc");
    }

    public void addSortDesc(String property) {
        this.parameters.addParameter(this.prefixWithTableId + "s_" + property, "asc");
    }

    public void addSortDefault(String property) {
        this.parameters.addParameter(this.prefixWithTableId + "s_" + property, "default");
    }

    public void doFilter() {
        this.parameters.addParameter(this.prefixWithTableId + "f_" + "a", "fa");
    }

    public void doClear() {
        this.parameters.addParameter(this.prefixWithTableId + "f_" + "a", "ca");
    }

    public void addExportView(String view) {
        this.parameters.addParameter(this.prefixWithTableId + "ev", view);
    }

    public void addExportFileName(String fileName) {
        this.parameters.addParameter(this.prefixWithTableId + "efn", fileName);
    }

    public String getFilter(String property) {
        return this.prefixWithTableId + "f_" + property;
    }
}

