/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.calc.CalcResult;
import org.extremecomponents.table.calc.CalcUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.view.ExportViewUtils;
import org.extremecomponents.table.view.View;
import org.extremecomponents.util.ExtremeUtils;

public class XlsView
implements View {
    private static Log logger = LogFactory.getLog(XlsView.class);
    public static final int WIDTH_MULT = 240;
    public static final int MIN_CHARS = 8;
    public static final short DEFAULT_FONT_HEIGHT = 8;
    public static final double NON_NUMERIC = -0.99999;
    public static final String DEFAULT_MONEY_FORMAT = "$###,###,##0.00";
    public static final String DEFAULT_PERCENT_FORMAT = "##0.0%";
    public static final String NBSP = "&nbsp;";
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private Map<String, HSSFCellStyle> styles;
    private short rownum;
    private short cellnum;
    private HSSFRow hssfRow;
    private String moneyFormat;
    private String percentFormat;
    private String encoding;

    @Override
    public void beforeBody(TableModel model) {
        logger.debug((Object)"XlsView.init()");
        this.moneyFormat = model.getPreferences().getPreference("table.exportableformat.money");
        if (StringUtils.isEmpty((CharSequence)this.moneyFormat)) {
            this.moneyFormat = DEFAULT_MONEY_FORMAT;
        }
        this.percentFormat = model.getPreferences().getPreference("table.exportableformat.percent");
        if (StringUtils.isEmpty((CharSequence)this.percentFormat)) {
            this.percentFormat = DEFAULT_PERCENT_FORMAT;
        }
        this.encoding = model.getExportHandler().getCurrentExport().getEncoding();
        this.wb = new HSSFWorkbook();
        this.sheet = this.wb.createSheet();
        this.wb.setSheetName(0, "Export Workbook");
        this.styles = this.initStyles(this.wb);
        HSSFPrintSetup ps = this.sheet.getPrintSetup();
        this.sheet.setAutobreaks(true);
        ps.setFitHeight((short)1);
        ps.setFitWidth((short)1);
        this.createHeader(model);
    }

    @Override
    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rownum = (short)(this.rownum + 1);
            this.cellnum = 0;
            this.hssfRow = this.sheet.createRow((int)this.rownum);
        }
        String value = ExportViewUtils.parseXLS(column.getCellDisplay());
        HSSFCell hssfCell = this.hssfRow.createCell((int)this.cellnum);
        this.setCellEncoding(hssfCell);
        if (column.isEscapeAutoFormat()) {
            this.writeToCellAsText(hssfCell, value, "");
        } else {
            this.writeToCellFormatted(hssfCell, value, "");
        }
        this.cellnum = (short)(this.cellnum + 1);
    }

    @Override
    public Object afterBody(TableModel model) {
        if (model.getLimit().getTotalRows() != 0) {
            this.totals(model);
        }
        return this.wb;
    }

    private void createHeader(TableModel model) {
        this.rownum = 0;
        this.cellnum = 0;
        HSSFRow row = this.sheet.createRow((int)this.rownum);
        List<Column> columns = model.getColumnHandler().getHeaderColumns();
        for (Column column : columns) {
            String title = column.getCellDisplay();
            HSSFCell hssfCell = row.createCell((int)this.cellnum);
            this.setCellEncoding(hssfCell);
            hssfCell.setCellStyle(this.styles.get("titleStyle"));
            hssfCell.setCellType(CellType.STRING);
            hssfCell.setCellValue(title);
            int valWidth = (title + "").length() * 240;
            this.sheet.setColumnWidth(hssfCell.getColumnIndex(), (int)((short)valWidth));
            this.cellnum = (short)(this.cellnum + 1);
        }
    }

    private void writeToCellAsText(HSSFCell cell, String value, String styleModifier) {
        if (value.trim().equals(NBSP)) {
            value = "";
        }
        cell.setCellStyle(this.styles.get("textStyle" + styleModifier));
        this.fixWidthAndPopulate(cell, -0.99999, value);
    }

    private void writeToCellFormatted(HSSFCell cell, String value, String styleModifier) {
        double numeric = -0.99999;
        try {
            numeric = Double.parseDouble(value);
        }
        catch (Exception e) {
            numeric = -0.99999;
        }
        if (value.startsWith("$") || value.endsWith("%") || value.startsWith("($")) {
            boolean moneyFlag = value.startsWith("$") || value.startsWith("($");
            boolean percentFlag = value.endsWith("%");
            value = StringUtils.replace((String)value, (String)"$", (String)"");
            value = StringUtils.replace((String)value, (String)"%", (String)"");
            value = StringUtils.replace((String)value, (String)",", (String)"");
            value = StringUtils.replace((String)value, (String)"(", (String)"-");
            value = StringUtils.replace((String)value, (String)")", (String)"");
            try {
                numeric = Double.parseDouble(value);
            }
            catch (Exception e) {
                numeric = -0.99999;
            }
            cell.setCellType(CellType.NUMERIC);
            if (moneyFlag) {
                cell.setCellStyle(this.styles.get("moneyStyle" + styleModifier));
            } else if (percentFlag) {
                numeric /= 100.0;
                cell.setCellStyle(this.styles.get("percentStyle" + styleModifier));
            }
        } else if (numeric != -0.99999) {
            cell.setCellStyle(this.styles.get("numericStyle" + styleModifier));
        } else {
            if (value.trim().equals(NBSP)) {
                value = "";
            }
            cell.setCellStyle(this.styles.get("textStyle" + styleModifier));
        }
        this.fixWidthAndPopulate(cell, numeric, value);
    }

    private void fixWidthAndPopulate(HSSFCell cell, double numeric, String value) {
        int valWidth = 0;
        if (numeric != -0.99999) {
            cell.setCellValue(numeric);
            valWidth = (cell.getNumericCellValue() + "$,.").length() * 240;
        } else {
            cell.setCellValue(value);
            valWidth = (cell.getStringCellValue() + "").length() * 240;
            if (valWidth < 1920) {
                valWidth = 1920;
            }
        }
        if (valWidth > this.sheet.getColumnWidth(cell.getColumnIndex())) {
            this.sheet.setColumnWidth(cell.getColumnIndex(), valWidth);
        }
    }

    private Map<String, HSSFCellStyle> initStyles(HSSFWorkbook wb) {
        return this.initStyles(wb, (short)8);
    }

    private Map<String, HSSFCellStyle> initStyles(HSSFWorkbook wb, short fontHeight) {
        HashMap<String, HSSFCellStyle> result = new HashMap<String, HSSFCellStyle>();
        HSSFCellStyle titleStyle = wb.createCellStyle();
        HSSFCellStyle textStyle = wb.createCellStyle();
        HSSFCellStyle boldStyle = wb.createCellStyle();
        HSSFCellStyle numericStyle = wb.createCellStyle();
        HSSFCellStyle numericStyleBold = wb.createCellStyle();
        HSSFCellStyle moneyStyle = wb.createCellStyle();
        HSSFCellStyle moneyStyleBold = wb.createCellStyle();
        HSSFCellStyle percentStyle = wb.createCellStyle();
        HSSFCellStyle percentStyleBold = wb.createCellStyle();
        HSSFCellStyle moneyStyle_Totals = wb.createCellStyle();
        HSSFCellStyle naStyle_Totals = wb.createCellStyle();
        HSSFCellStyle numericStyle_Totals = wb.createCellStyle();
        HSSFCellStyle percentStyle_Totals = wb.createCellStyle();
        HSSFCellStyle textStyle_Totals = wb.createCellStyle();
        result.put("titleStyle", titleStyle);
        result.put("textStyle", textStyle);
        result.put("boldStyle", boldStyle);
        result.put("numericStyle", numericStyle);
        result.put("numericStyleBold", numericStyleBold);
        result.put("moneyStyle", moneyStyle);
        result.put("moneyStyleBold", moneyStyleBold);
        result.put("percentStyle", percentStyle);
        result.put("percentStyleBold", percentStyleBold);
        result.put("moneyStyle_Totals", moneyStyle_Totals);
        result.put("naStyle_Totals", naStyle_Totals);
        result.put("numericStyle_Totals", numericStyle_Totals);
        result.put("percentStyle_Totals", percentStyle_Totals);
        result.put("textStyle_Totals", textStyle_Totals);
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont font = wb.createFont();
        font.setBold(false);
        font.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        font.setFontName("Arial");
        font.setFontHeightInPoints(fontHeight);
        HSSFFont fontBold = wb.createFont();
        fontBold.setBold(true);
        fontBold.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        fontBold.setFontName("Arial");
        fontBold.setFontHeightInPoints(fontHeight);
        moneyStyle.setFont(font);
        moneyStyle.setAlignment(HorizontalAlignment.RIGHT);
        moneyStyle.setDataFormat(format.getFormat(this.moneyFormat));
        moneyStyleBold.setFont(fontBold);
        moneyStyleBold.setAlignment(HorizontalAlignment.RIGHT);
        moneyStyleBold.setDataFormat(format.getFormat(this.moneyFormat));
        percentStyle.setFont(font);
        percentStyle.setAlignment(HorizontalAlignment.RIGHT);
        percentStyle.setDataFormat(format.getFormat(this.percentFormat));
        percentStyleBold.setFont(fontBold);
        percentStyleBold.setAlignment(HorizontalAlignment.RIGHT);
        percentStyleBold.setDataFormat(format.getFormat(this.percentFormat));
        numericStyle.setFont(font);
        numericStyle.setAlignment(HorizontalAlignment.RIGHT);
        numericStyleBold.setFont(fontBold);
        numericStyleBold.setAlignment(HorizontalAlignment.RIGHT);
        titleStyle.setFont(font);
        titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleStyle.setBorderBottom(BorderStyle.THIN);
        titleStyle.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleStyle.setBorderLeft(BorderStyle.THIN);
        titleStyle.setLeftBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleStyle.setBorderRight(BorderStyle.THIN);
        titleStyle.setRightBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleStyle.setBorderTop(BorderStyle.THIN);
        titleStyle.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        textStyle.setFont(font);
        textStyle.setWrapText(true);
        boldStyle.setFont(fontBold);
        boldStyle.setWrapText(true);
        moneyStyle_Totals.setFont(fontBold);
        moneyStyle_Totals.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        moneyStyle_Totals.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        moneyStyle_Totals.setBorderBottom(BorderStyle.THIN);
        moneyStyle_Totals.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        moneyStyle_Totals.setBorderTop(BorderStyle.THIN);
        moneyStyle_Totals.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        moneyStyle_Totals.setAlignment(HorizontalAlignment.RIGHT);
        moneyStyle_Totals.setVerticalAlignment(VerticalAlignment.CENTER);
        moneyStyle_Totals.setDataFormat(format.getFormat(this.moneyFormat));
        naStyle_Totals.setFont(fontBold);
        naStyle_Totals.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        naStyle_Totals.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        naStyle_Totals.setBorderBottom(BorderStyle.THIN);
        naStyle_Totals.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        naStyle_Totals.setBorderTop(BorderStyle.THIN);
        naStyle_Totals.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        naStyle_Totals.setAlignment(HorizontalAlignment.RIGHT);
        naStyle_Totals.setVerticalAlignment(VerticalAlignment.CENTER);
        numericStyle_Totals.setFont(fontBold);
        numericStyle_Totals.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        numericStyle_Totals.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numericStyle_Totals.setBorderBottom(BorderStyle.THIN);
        numericStyle_Totals.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        numericStyle_Totals.setBorderTop(BorderStyle.THIN);
        numericStyle_Totals.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        numericStyle_Totals.setAlignment(HorizontalAlignment.RIGHT);
        numericStyle_Totals.setVerticalAlignment(VerticalAlignment.CENTER);
        percentStyle_Totals.setFont(fontBold);
        percentStyle_Totals.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        percentStyle_Totals.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        percentStyle_Totals.setBorderBottom(BorderStyle.THIN);
        percentStyle_Totals.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        percentStyle_Totals.setBorderTop(BorderStyle.THIN);
        percentStyle_Totals.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        percentStyle_Totals.setAlignment(HorizontalAlignment.RIGHT);
        percentStyle_Totals.setVerticalAlignment(VerticalAlignment.CENTER);
        percentStyle_Totals.setDataFormat(format.getFormat(this.percentFormat));
        textStyle_Totals.setFont(fontBold);
        textStyle_Totals.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        textStyle_Totals.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        textStyle_Totals.setBorderBottom(BorderStyle.THIN);
        textStyle_Totals.setBottomBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        textStyle_Totals.setBorderTop(BorderStyle.THIN);
        textStyle_Totals.setTopBorderColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        textStyle_Totals.setAlignment(HorizontalAlignment.LEFT);
        textStyle_Totals.setVerticalAlignment(VerticalAlignment.CENTER);
        return result;
    }

    public void totals(TableModel model) {
        Column firstCalcColumn = model.getColumnHandler().getFirstCalcColumn();
        if (firstCalcColumn != null) {
            int rows = firstCalcColumn.getCalc().length;
            for (int i = 0; i < rows; ++i) {
                this.rownum = (short)(this.rownum + 1);
                HSSFRow row = this.sheet.createRow((int)this.rownum);
                this.cellnum = 0;
                for (Column column : model.getColumnHandler().getColumns()) {
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        HSSFCell cell = row.createCell((int)this.cellnum);
                        this.setCellEncoding(cell);
                        if (column.isEscapeAutoFormat()) {
                            this.writeToCellAsText(cell, calcTitle, "_Totals");
                        } else {
                            this.writeToCellFormatted(cell, calcTitle, "_Totals");
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    if (column.isCalculated()) {
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        Number value = calcResult.getValue();
                        HSSFCell cell = row.createCell((int)this.cellnum);
                        this.setCellEncoding(cell);
                        if (value != null) {
                            if (column.isEscapeAutoFormat()) {
                                this.writeToCellAsText(cell, value.toString(), "_Totals");
                            } else {
                                this.writeToCellFormatted(cell, ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()), "_Totals");
                            }
                        } else {
                            cell.setCellStyle(this.styles.get("naStyle_Totals"));
                            cell.setCellValue("n/a");
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    HSSFCell cell = row.createCell((int)this.cellnum);
                    this.setCellEncoding(cell);
                    this.writeToCellFormatted(cell, "", "_Totals");
                    this.cellnum = (short)(this.cellnum + 1);
                }
            }
        }
    }

    private void setCellEncoding(HSSFCell cell) {
    }
}

