/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.handler;

import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

public class TableHandler {
    protected TableModel model;
    private Table table;

    public TableHandler(TableModel model) {
        this.model = model;
    }

    public Table getTable() {
        return this.table;
    }

    public void addTable(Table table) {
        this.table = table;
        this.addTableAttributes();
        table.defaults();
    }

    public void addTableAttributes() {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, this.table.getInterceptor(), "table.interceptor.");
        this.table.setInterceptor(interceptor);
        TableCache.getInstance().getTableInterceptor(interceptor).addTableAttributes(this.model, this.table);
    }

    public String prefixWithTableId() {
        return this.table.getTableId() + "_";
    }

    public Integer getTotalRows() {
        return (Integer)this.table.getAttribute("totalRows");
    }

    public void setTotalRows(Integer totalRows) {
        this.table.addAttribute("totalRows", totalRows);
    }
}

