/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.extremecomponents.table.core.Preferences;
import org.extremecomponents.table.filter.ViewResolver;

public class PdfViewResolver
implements ViewResolver {
    private static final String USERCONFIG_LOCATION = "exportPdf.userconfigLocation";

    @Override
    public void resolveView(ServletRequest request, ServletResponse response, Preferences preferences, Object viewData) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(((String)viewData).getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerFactory tfact = TransformerFactory.newInstance();
        tfact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tfact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        URL configUrl = this.getClass().getResource("fop.xconf");
        String userconfigLocation = preferences.getPreference(USERCONFIG_LOCATION);
        if (userconfigLocation != null) {
            configUrl = this.getClass().getResource(userconfigLocation);
        }
        FopFactory fopFactory = new FopFactoryBuilder(configUrl.toURI()).build();
        Fop fop = fopFactory.newFop("application/pdf", (OutputStream)out);
        Transformer transformer = tfact.newTransformer();
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        StreamSource streamSource = new StreamSource(is);
        transformer.transform(streamSource, new SAXResult(fop.getDefaultHandler()));
        byte[] contents = out.toByteArray();
        response.setContentLength(contents.length);
        response.getOutputStream().write(contents);
    }
}

