/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.context;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.TableModelUtils;

public class HttpServletRequestContext
implements Context {
    private HttpServletRequest request;
    private Map parameterMap;

    public HttpServletRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequestContext(HttpServletRequest request, Map parameterMap) {
        this(request);
        this.parameterMap = parameterMap;
    }

    @Override
    public Object getApplicationInitParameter(String name) {
        return this.request.getSession().getServletContext().getInitParameter(name);
    }

    @Override
    public Object getApplicationAttribute(String name) {
        return this.request.getSession().getServletContext().getAttribute(name);
    }

    @Override
    public void setApplicationAttribute(String name, Object value) {
        this.request.getSession().getServletContext().setAttribute(name, value);
    }

    @Override
    public void removeApplicationAttribute(String name) {
        this.request.getSession().getServletContext().removeAttribute(name);
    }

    @Override
    public Object getPageAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setPageAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public void removePageAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Override
    public String getParameter(String name) {
        String[] values;
        if (this.parameterMap != null && (values = TableModelUtils.getValueAsArray(this.parameterMap.get(name))) != null && values.length > 0) {
            return values[0];
        }
        return this.request.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap != null) {
            return this.parameterMap;
        }
        return this.request.getParameterMap();
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public void removeRequestAttribute(String name) {
        this.request.removeAttribute(name);
    }

    @Override
    public Object getSessionAttribute(String name) {
        return this.request.getSession().getAttribute(name);
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        this.request.getSession().setAttribute(name, value);
    }

    @Override
    public void removeSessionAttribute(String name) {
        this.request.getSession().removeAttribute(name);
    }

    @Override
    public Writer getWriter() {
        return new StringWriter();
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public Object getContextObject() {
        return this.request;
    }
}

