/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.crypto.CipherParameters;
import org.opennms.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import org.opennms.shaded.org.bouncycastle.crypto.Wrapper;
import org.opennms.shaded.org.bouncycastle.crypto.engines.RC2WrapEngine;
import org.opennms.shaded.org.bouncycastle.crypto.params.KeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.ParametersWithIV;
import org.opennms.shaded.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.opennms.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEDHPrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCEPBEKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKDSAPrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.JDKGOST3410PrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.provider.PBE;

public abstract class WrapCipherSpi
extends CipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class, PBEParameterSpec.class, RC2ParameterSpec.class, RC5ParameterSpec.class};
    protected int pbeType = 2;
    protected int pbeHash = 1;
    protected int pbeKeySize;
    protected int pbeIvSize;
    protected AlgorithmParameters engineParams = null;
    protected Wrapper wrapEngine = null;
    private int ivSize;
    private byte[] iv;

    protected WrapCipherSpi() {
    }

    protected WrapCipherSpi(Wrapper wrapper) {
        this(wrapper, 0);
    }

    protected WrapCipherSpi(Wrapper wrapper, int n) {
        this.wrapEngine = wrapper;
        this.ivSize = n;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return (byte[])this.iv.clone();
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length;
    }

    protected int engineGetOutputSize(int n) {
        return -1;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("can't support mode " + string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + string + " unknown.");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var5_12;
        Object object;
        if (key instanceof JCEPBEKey) {
            object = (JCEPBEKey)key;
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                CipherParameters cipherParameters = PBE.Util.makePBEParameters((JCEPBEKey)object, algorithmParameterSpec, this.wrapEngine.getAlgorithmName());
            } else {
                if (((JCEPBEKey)object).getParam() == null) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                CipherParameters cipherParameters = ((JCEPBEKey)object).getParam();
            }
        } else {
            KeyParameter keyParameter = new KeyParameter(key.getEncoded());
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            void var5_10;
            object = (IvParameterSpec)algorithmParameterSpec;
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_10, ((IvParameterSpec)object).getIV());
        }
        if (var5_12 instanceof KeyParameter && this.ivSize != 0) {
            this.iv = new byte[this.ivSize];
            secureRandom.nextBytes(this.iv);
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_12, this.iv);
        }
        switch (n) {
            case 3: {
                void var5_14;
                this.wrapEngine.init(true, (CipherParameters)var5_14);
                return;
            }
            case 4: {
                void var5_14;
                this.wrapEngine.init(false, (CipherParameters)var5_14);
                return;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("engine only valid for wrapping");
            }
            default: {
                System.out.println("eeek!");
            }
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineParams = algorithmParameters;
        this.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        throw new RuntimeException("not supported for wrapping");
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        throw new RuntimeException("not supported for wrapping");
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return null;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            if (this.wrapEngine == null) {
                return this.engineDoFinal(byArray, 0, byArray.length);
            }
            return this.wrapEngine.wrap(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException {
        byte[] byArray2;
        try {
            byArray2 = this.wrapEngine == null ? this.engineDoFinal(byArray, 0, byArray.length) : this.wrapEngine.unwrap(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidKeyException(invalidCipherTextException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        if (n == 3) {
            return new SecretKeySpec(byArray2, string);
        }
        if (string.equals("") && n == 2) {
            PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier;
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray2);
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(aSN1Sequence);
                DERObjectIdentifier dERObjectIdentifier = privateKeyInfo.getAlgorithmId().getObjectId();
                pKCS12BagAttributeCarrier = dERObjectIdentifier.equals(X9ObjectIdentifiers.id_ecPublicKey) ? new JCEECPrivateKey(privateKeyInfo) : (dERObjectIdentifier.equals(CryptoProObjectIdentifiers.gostR3410_94) ? new JDKGOST3410PrivateKey(privateKeyInfo) : (dERObjectIdentifier.equals(X9ObjectIdentifiers.id_dsa) ? new JDKDSAPrivateKey(privateKeyInfo) : (dERObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement) ? new JCEDHPrivateKey(privateKeyInfo) : (dERObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber) ? new JCEDHPrivateKey(privateKeyInfo) : new JCERSAPrivateCrtKey(privateKeyInfo)))));
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid key encoding.");
            }
            return pKCS12BagAttributeCarrier;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, BouncyCastleProvider.PROVIDER_NAME);
            if (n == 1) {
                return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
            }
            if (n == 2) {
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Unknown key type " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + n);
    }

    public static class RC2Wrap
    extends WrapCipherSpi {
        public RC2Wrap() {
            super(new RC2WrapEngine());
        }
    }
}

