/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.standard;

import java.util.LinkedList;
import net.jradius.exception.StandardViolatedException;
import net.jradius.packet.RadiusPacket;
import net.jradius.standard.RadiusStandard;

public class WISPrStandard
extends RadiusStandard {
    static final long[] requiredAccessRequest = new long[]{1L, 2L, 4L, 6L, 8L, 24L, 30L, 32L, 44L, 61L};
    static final long[] requiredAccessAccept = new long[]{18L, 24L, 25L, 27L, 28L, 44L, 85L};
    static final long[] requiredAccounting = new long[]{1L, 4L, 8L, 25L, 30L, 32L, 40L, 41L, 42L, 43L, 44L, 46L, 47L, 48L, 61L};

    public String getName() {
        return "WISPr";
    }

    public void checkPacket(RadiusPacket p, long[] ignore) throws StandardViolatedException {
        LinkedList missing = new LinkedList();
        switch (p.getCode()) {
            case 1: {
                WISPrStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccessRequest, (long[])ignore);
                break;
            }
            case 2: {
                WISPrStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccessAccept, (long[])ignore);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                WISPrStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccounting, (long[])ignore);
            }
        }
        if (!missing.isEmpty()) {
            throw new StandardViolatedException(((Object)((Object)this)).getClass(), missing);
        }
    }
}

