/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.session;

import java.io.Serializable;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.DHCPPacket;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.value.AttributeValue;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.SessionKeyProvider;

public class RadiusSessionKeyProvider
implements SessionKeyProvider {
    public Serializable getRequestSessionKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        if (req == null) {
            return null;
        }
        if (req instanceof AccessRequest) {
            return this.getAccessRequestKey(request);
        }
        if (req instanceof DHCPPacket) {
            return this.getDHCPRequestKey(request);
        }
        if (req instanceof AccountingRequest) {
            int type = request.getType();
            int status = ((AccountingRequest)req).getAccountingStatusType();
            Serializable key = this.getAccountingRequestKey(request);
            if (type == 3 && (status == 1 || status == 7)) {
                return new Serializable[]{this.getAccessRequestKey(request), key};
            }
            return key;
        }
        return null;
    }

    public Serializable getAccessRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 4L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 32L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 1L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30L, false));
        return sb.toString();
    }

    public Serializable getDHCPRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 3539210L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 3539204L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 3539211L, true));
        return sb.toString();
    }

    public Serializable getClassKey(JRadiusRequest request) throws RadiusException {
        String sClass;
        RadiusPacket req = request.getRequestPacket();
        byte[] bClass = (byte[])req.getAttributeValue(25L);
        if (bClass != null && (sClass = new String(bClass)).startsWith("JRADIUS-CLASS:")) {
            RadiusLog.debug((String)("Using " + sClass));
            return sClass.substring("JRADIUS-CLASS:".length());
        }
        bClass = (byte[])req.getAttributeValue(24L);
        if (bClass != null && (sClass = new String(bClass)).startsWith("JRADIUS-CLASS:")) {
            RadiusLog.debug((String)("Using " + sClass));
            return sClass.substring("JRADIUS-CLASS:".length());
        }
        return null;
    }

    public Serializable getAccountingRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 4L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 44L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 32L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 1L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30L, false));
        return sb.toString();
    }

    public Serializable getAppSessionKey(JRadiusRequest request) throws RadiusException {
        AttributeList ci = request.getConfigItems();
        RadiusAttribute a = ci.get(1259012098L);
        if (a != null) {
            return a.getValue().getValueObject();
        }
        return null;
    }

    public Serializable getTunneledRequestKey(JRadiusRequest request) throws RadiusException {
        RadiusPacket req = request.getRequestPacket();
        StringBuffer sb = new StringBuffer((String)request.getSender());
        sb.append(":").append(this.getKeyFromAttributeType(req, 32L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 4L, true));
        sb.append(":").append(this.getKeyFromAttributeType(req, 44L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 31L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 30L, false));
        sb.append(":").append(this.getKeyFromAttributeType(req, 6L, false));
        return sb.toString();
    }

    protected Serializable getKeyFromAttributeType(RadiusPacket req, long type, boolean required) throws RadiusException {
        RadiusAttribute a = req.findAttribute(type);
        if (a == null) {
            if (required) {
                a = AttributeFactory.newAttribute((long)type, null, (boolean)false);
                throw new RadiusException("Missing required attribute: " + a.getAttributeName());
            }
            return null;
        }
        AttributeValue v = a.getValue();
        return v.toString();
    }
}

