/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.tlstunnel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.jradius.dictionary.Attr_EAPType;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.value.NamedValue;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.session.RadiusSessionKeyProvider;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.chain.Catalog;

public class AuthorizeHandler
extends RadiusSessionHandler {
    private HashMap terminatedRealms = new HashMap();
    private Cache tlsTunnels;
    private String anonUserName;
    private String chainName;

    public boolean handle(JRadiusRequest request) throws Exception {
        RadiusPacket req = request.getRequestPacket();
        AttributeList ci = request.getConfigItems();
        JRadiusSession session = request.getSession();
        String username = (String)req.getAttributeValue(1L);
        String realm = session.getRealm();
        Attr_EAPType eap = (Attr_EAPType)req.findAttribute(1018L);
        if (eap != null) {
            NamedValue eapv = (NamedValue)eap.getValue();
            String eapType = eapv.getValueString();
            if (session.isSecured()) {
                Catalog catalog = this.getCatalog();
                if (catalog != null && this.chainName != null) {
                    JRCommand c = (JRCommand)catalog.getCommand(this.chainName);
                    if (c == null) {
                        RadiusLog.error((String)("There is no command '" + this.chainName + "' in catalog " + this.getCatalogName()));
                        return false;
                    }
                    return this.execute(c, (JRadiusEvent)request);
                }
            } else if ((Attr_EAPType.Identity.equals(eapType) || Attr_EAPType.NAK.equals(eapType) || Attr_EAPType.EAPTTLS.equals(eapType) || Attr_EAPType.PEAP.equals(eapType)) && (this.anonUserName != null && this.anonUserName.equals(username) || this.terminatedRealms.containsKey(realm))) {
                RadiusSessionKeyProvider skp = (RadiusSessionKeyProvider)JRadiusSessionManager.getManager((Object)request.getSender()).getSessionKeyProvider(request.getSender());
                session.getLogEntry(request).setType("tls-tunnel");
                ci.remove(1048L);
                this.tlsTunnels.put(new Element(skp.getTunneledRequestKey(request), (Serializable)((Object)session.getSessionKey())));
                RadiusLog.info((String)("EAP-TTLS Termination: username = " + username + ", session = " + session.getSessionKey()));
                return true;
            }
        }
        return false;
    }

    public String getAnonUserName() {
        return this.anonUserName;
    }

    public void setAnonUserName(String anonUserName) {
        this.anonUserName = anonUserName;
    }

    public void setTerminatedRealms(String realms) {
        StringTokenizer st = new StringTokenizer(realms, ",");
        while (st.hasMoreTokens()) {
            String realm = st.nextToken();
            this.terminatedRealms.put(realm.trim().toLowerCase(), realm);
        }
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public void setTlsTunnels(Cache tlsTunnels) {
        this.tlsTunnels = tlsTunnels;
    }
}

