/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.proxy;

import net.jradius.handler.RadiusSessionHandler;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;

public class ProxyClassHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws Exception {
        byte[] sessionState;
        JRadiusSession session = request.getSession();
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket req = request.getRequestPacket();
        byte[] packetClass = (byte[])req.getAttributeValue(25L);
        byte[][] sessionClass = session.getRadiusClass();
        if (packetClass != null || sessionClass != null) {
            if (sessionClass == null) {
                session.addLogMessage(request, "Request has Class attribute when it should not");
            } else {
                session.addLogMessage(request, "Missing Class Attribute (added)");
                req.removeAttribute(25L);
                for (byte[] a : sessionClass) {
                    req.addAttribute(AttributeFactory.newAttribute((long)25L, (byte[])a, (boolean)req.isRecyclable()));
                }
            }
        }
        if (req instanceof AccessRequest && (sessionState = session.getRadiusState()) != null) {
            req.overwriteAttribute(AttributeFactory.newAttribute((long)24L, (byte[])sessionState, (boolean)req.isRecyclable()));
        }
        return false;
    }
}

