/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.rtc.Node;
import org.opennms.web.category.AvailabilityIpInterface;

@XmlRootElement(name="node")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AvailabilityNode {
    @XmlAttribute(name="id")
    private Long m_nodeId;
    @XmlAttribute(name="availability")
    private Double m_availability;
    @XmlAttribute(name="service-count")
    private Long m_serviceCount;
    @XmlAttribute(name="service-down-count")
    private Long m_serviceDownCount;
    @XmlElementWrapper(name="ipinterfaces")
    @XmlElement(name="ipinterface")
    private final List<AvailabilityIpInterface> m_ipInterfaces = new ArrayList<AvailabilityIpInterface>();

    public AvailabilityNode() {
        this.m_nodeId = -1L;
        this.m_availability = -1.0;
        this.m_serviceCount = 0L;
        this.m_serviceDownCount = 0L;
    }

    public AvailabilityNode(Node node) {
        this.m_nodeId = node.getNodeid();
        this.m_availability = node.getNodevalue();
        this.m_serviceCount = node.getNodesvccount();
        this.m_serviceDownCount = node.getNodesvcdowncount();
    }

    public AvailabilityNode(OnmsNode node, double availability) {
        this.m_nodeId = node.getId().longValue();
        this.m_availability = availability;
        this.m_serviceCount = 0L;
        this.m_serviceDownCount = 0L;
        for (OnmsIpInterface iface : node.getIpInterfaces()) {
            for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
                Long l = this.m_serviceCount;
                this.m_serviceCount = this.m_serviceCount + 1L;
                if (!svc.isDown()) continue;
                l = this.m_serviceDownCount;
                this.m_serviceDownCount = this.m_serviceDownCount + 1L;
            }
        }
    }

    public Long getId() {
        return this.m_nodeId;
    }

    public void addIpInterface(AvailabilityIpInterface iface) {
        this.m_ipInterfaces.add(iface);
    }

    public Double getAvailability() {
        return this.m_availability;
    }

    public List<AvailabilityIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public Long getServiceCount() {
        return this.m_serviceCount;
    }

    public Long getServiceDownCount() {
        return this.m_serviceDownCount;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("availability", (Object)this.getAvailability()).append("serviceCount", (Object)this.getServiceCount()).append("serviceDownCount", (Object)this.getServiceDownCount()).append("ipInterfaces", this.getIpInterfaces()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AvailabilityNode)) {
            return false;
        }
        AvailabilityNode that = (AvailabilityNode)o;
        return new EqualsBuilder().append((Object)this.getId(), (Object)that.getId()).append((Object)this.getAvailability(), (Object)that.getAvailability()).append((Object)this.getServiceCount(), (Object)that.getServiceCount()).append((Object)this.getServiceDownCount(), (Object)that.getServiceDownCount()).append(this.getIpInterfaces(), that.getIpInterfaces()).isEquals();
    }
}

