/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.geocoder.mapquest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.utils.StringUtils;
import org.opennms.features.geocoder.ConfigurationUtils;
import org.opennms.features.geocoder.GeocoderConfiguration;
import org.opennms.features.geocoder.GeocoderConfigurationException;

public class MapquestConfiguration
extends GeocoderConfiguration {
    static final String URL_KEY = "url";
    static final String API_KEY_KEY = "apiKey";
    static final String USE_SYSTEM_PROXY_KEY = "useSystemProxy";
    private String urlTemplate;
    private String apiKey;
    private boolean useSystemProxy;

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean isUseSystemProxy() {
        return this.useSystemProxy;
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.useSystemProxy = useSystemProxy;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void validate() throws GeocoderConfigurationException {
        if (StringUtils.isEmpty((String)this.urlTemplate)) {
            throw new GeocoderConfigurationException(URL_KEY, "Please provide a value");
        }
        if (StringUtils.isEmpty((String)this.apiKey)) {
            throw new GeocoderConfigurationException(API_KEY_KEY, "Please provide a value");
        }
        try {
            new URL(this.urlTemplate);
        }
        catch (MalformedURLException e) {
            throw new GeocoderConfigurationException(URL_KEY, "The provided URL ''{0}'' is not valid: ''{1}''", new Object[]{this.urlTemplate, e.getMessage()});
        }
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(URL_KEY, this.urlTemplate);
        properties.put(API_KEY_KEY, this.apiKey);
        properties.put(USE_SYSTEM_PROXY_KEY, this.useSystemProxy);
        return properties;
    }

    public static MapquestConfiguration fromMap(Map<String, Object> properties) {
        MapquestConfiguration configuration = new MapquestConfiguration();
        configuration.setUrlTemplate((String)ConfigurationUtils.getValue(properties, (String)URL_KEY, null));
        configuration.setApiKey((String)ConfigurationUtils.getValue(properties, (String)API_KEY_KEY, null));
        configuration.setUseSystemProxy(ConfigurationUtils.getBoolean(properties, (String)USE_SYSTEM_PROXY_KEY, (Boolean)false));
        return configuration;
    }

    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.apiKey, this.urlTemplate, this.useSystemProxy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MapquestConfiguration)) {
            return false;
        }
        MapquestConfiguration that = (MapquestConfiguration)((Object)obj);
        return Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.urlTemplate, that.urlTemplate) && this.useSystemProxy == that.useSystemProxy;
    }
}

