/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.application.browsers;

import com.vaadin.server.Page;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.Table;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.opennms.features.topology.api.browsers.AbstractSelectionLinkGenerator;
import org.opennms.features.topology.api.support.DialogWindow;
import org.opennms.features.topology.api.support.InfoWindow;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsOutage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOutageSelectionLinkGenerator
extends AbstractSelectionLinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationOutageSelectionLinkGenerator.class);
    private final String idPropertyName;
    private final OutageDao outageDao;

    public ApplicationOutageSelectionLinkGenerator(String idPropertyName, OutageDao outageDao) {
        this.idPropertyName = idPropertyName;
        this.outageDao = outageDao;
    }

    public Object generateCell(final Table source, Object itemId, Object columnId) {
        if (source == null) {
            return null;
        }
        Property idProperty = source.getContainerProperty(itemId, (Object)this.idPropertyName);
        final Integer outageId = (Integer)idProperty.getValue();
        if (outageId == null) {
            return null;
        }
        Button button = new Button("" + outageId);
        button.setStyleName("link");
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 3698209256202413810L;

            public void buttonClick(Button.ClickEvent event) {
                OnmsOutage outage = (OnmsOutage)ApplicationOutageSelectionLinkGenerator.this.outageDao.get((Serializable)outageId);
                if (outage == null) {
                    new DialogWindow(source.getUI(), "Outage does not exist!", "The outage information cannot be shown. \nThe outage does not exist anymore. \n\nPlease refresh the Outage Table.");
                    return;
                }
                URI currentLocation = Page.getCurrent().getLocation();
                String contextRoot = VaadinServlet.getCurrent().getServletContext().getContextPath();
                String redirectFragment = contextRoot + "/outage/detail.htm?quiet=true&id=" + outageId;
                LOG.debug("outage {} clicked, current location = {}, uri = {}", new Object[]{outageId, currentLocation, redirectFragment});
                try {
                    source.getUI().addWindow((Window)new InfoWindow(new URL(currentLocation.toURL(), redirectFragment), () -> "Outage Info " + outageId));
                }
                catch (MalformedURLException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        return button;
    }
}

