/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tracker;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.tracker.Request;
import org.opennms.core.tracker.RequestLocator;
import org.opennms.core.tracker.ResponseWithId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDBasedRequestLocator<ReqIdT, ReqT extends Request<ReqIdT, ReqT, ReplyT>, ReplyT extends ResponseWithId<ReqIdT>>
implements RequestLocator<ReqT, ReplyT> {
    private static final Logger s_log = LoggerFactory.getLogger(IDBasedRequestLocator.class);
    private Map<ReqIdT, ReqT> m_pendingRequests = new HashMap<ReqIdT, ReqT>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReqT requestTimedOut(ReqT timedOutRequest) {
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            Request pendingRequest = (Request)this.m_pendingRequests.get(timedOutRequest.getId());
            if (pendingRequest == timedOutRequest) {
                this.m_pendingRequests.remove(timedOutRequest.getId());
            }
            return (ReqT)pendingRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestComplete(ReqT request) {
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            this.m_pendingRequests.remove(request.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReqT locateMatchingRequest(ReplyT reply) {
        Object id = reply.getRequestId();
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            s_log.debug("Looking for request with Id: {} in map {}", id, this.m_pendingRequests);
            return (ReqT)((Request)this.m_pendingRequests.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trackRequest(ReqT request) {
        Map<ReqIdT, ReqT> map = this.m_pendingRequests;
        synchronized (map) {
            Request oldRequest = (Request)this.m_pendingRequests.get(request.getId());
            if (oldRequest != null) {
                request.processError(new IllegalStateException("Duplicate request; keeping old request: " + String.valueOf(oldRequest) + "; removing new request: " + String.valueOf(request)));
                return false;
            }
            this.m_pendingRequests.put(request.getId(), request);
        }
        return true;
    }
}

