/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.opennms.core.ipc.sink.api.DispatchQueueFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchQueueServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DispatchQueueServiceLoader.class);
    private static BundleContext context;
    private static volatile DispatchQueueFactory dispatchQueueFactory;

    public BundleContext getBundleContext() {
        return context;
    }

    public static void setBundleContext(BundleContext bundleContext) {
        context = bundleContext;
    }

    public static Optional<DispatchQueueFactory> getDispatchQueueFactory() {
        if (dispatchQueueFactory != null) {
            return Optional.of(dispatchQueueFactory);
        }
        if (context != null) {
            try {
                ServiceReference serviceReference = context.getServiceReference(DispatchQueueFactory.class);
                return serviceReference == null ? Optional.empty() : Optional.of((DispatchQueueFactory)context.getService(serviceReference));
            }
            catch (Exception e) {
                LOG.error("Exception while retrieving DispatchQueueFactory Service from registry", (Throwable)e);
                throw e;
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    public static void setDispatchQueue(DispatchQueueFactory factory) {
        dispatchQueueFactory = factory;
    }
}

