/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.NullStringAdapter;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.xml.eventconf.MechanismType;
import org.opennms.netmgt.xml.eventconf.StateType;

@XmlRootElement(name="forward")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
public class Forward
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlValue
    @XmlJavaTypeAdapter(value=NullStringAdapter.class)
    private String m_content;
    @XmlAttribute(name="state", required=false)
    private StateType m_state;
    @XmlAttribute(name="mechanism", required=false)
    private MechanismType m_mechanism;

    public String getContent() {
        return this.m_content;
    }

    public MechanismType getMechanism() {
        return this.m_mechanism == null ? MechanismType.SNMPUDP : this.m_mechanism;
    }

    public StateType getState() {
        return this.m_state == null ? StateType.OFF : this.m_state;
    }

    public void setContent(String content) {
        this.m_content = ConfigUtils.normalizeAndInternString(content);
    }

    public void setMechanism(MechanismType mechanism) {
        this.m_mechanism = mechanism;
    }

    public void setState(StateType state) {
        this.m_state = state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.m_content, this.m_state, this.m_mechanism});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Forward) {
            Forward that = (Forward)obj;
            return Objects.equals(this.m_content, that.m_content) && Objects.equals((Object)this.m_state, (Object)that.m_state) && Objects.equals((Object)this.m_mechanism, (Object)that.m_mechanism);
        }
        return false;
    }
}

