/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import com.google.common.base.MoreObjects;
import java.util.concurrent.atomic.AtomicInteger;

public class EventOrdering
implements Comparable<EventOrdering> {
    private final EventOrdering m_parent;
    private final int m_sequenceIndex;
    private final AtomicInteger m_nextSubsequence = new AtomicInteger(0);
    private final AtomicInteger m_nextIndex = new AtomicInteger(0);

    public EventOrdering() {
        this(null, 0);
    }

    private EventOrdering(EventOrdering parent, int sequenceIndex) {
        this.m_parent = parent;
        this.m_sequenceIndex = sequenceIndex;
    }

    public EventOrderIndex next() {
        int nextIndex = this.m_nextIndex.getAndIncrement();
        return new EventOrderIndex(this, nextIndex);
    }

    public EventOrdering subsequence() {
        int nextSubsequence = this.m_nextSubsequence.getAndIncrement();
        return new EventOrdering(this, nextSubsequence);
    }

    @Override
    public int compareTo(EventOrdering o) {
        int parentCompare = this.compareParents(this.m_parent, o.m_parent);
        if (parentCompare != 0) {
            return parentCompare;
        }
        return this.m_sequenceIndex - o.m_sequenceIndex;
    }

    private int compareParents(EventOrdering parent1, EventOrdering parent2) {
        if (parent1 == parent2) {
            return 0;
        }
        if (parent1 == null) {
            return -1;
        }
        if (parent2 == null) {
            return 1;
        }
        return parent1.compareTo(parent2);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.m_parent).add("idx", this.m_sequenceIndex).toString();
    }

    public static class EventOrderIndex
    implements Comparable<EventOrderIndex> {
        private final EventOrdering m_ordering;
        private final int m_index;

        private EventOrderIndex(EventOrdering ordering, int index) {
            this.m_ordering = ordering;
            this.m_index = index;
        }

        @Override
        public int compareTo(EventOrderIndex orderIndex) {
            int parentOrder = this.m_ordering.compareTo(orderIndex.m_ordering);
            if (parentOrder != 0) {
                return parentOrder;
            }
            return this.m_index - orderIndex.m_index;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.m_ordering).add("idx", this.m_index).toString();
        }
    }
}

